"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useLoadingStateContext = exports.useLoadingState = exports.LoadingStateProvider = void 0;
var _rxjs = require("rxjs");
var _constate = _interopRequireDefault(require("constate"));
var _react = require("react");
var _public = require("@kbn/data-plugin/public");
var _use_kibana = require("../../../hooks/use_kibana");
var _use_date_picker = require("./use_date_picker");
var _use_search_session = require("../../../hooks/use_search_session");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const WAIT_MS = 1000;
const useLoadingState = () => {
  const {
    autoRefreshTick$,
    autoRefreshConfig$
  } = (0, _use_date_picker.useDatePickerContext)();
  const {
    services
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const {
    data: {
      search
    }
  } = services;
  const {
    updateSearchSessionId
  } = (0, _use_search_session.useSearchSessionContext)();
  const isAutoRefreshRequestPending$ = (0, _react.useMemo)(() => new _rxjs.BehaviorSubject(false), []);
  const requestsCount$ = (0, _react.useMemo)(() => new _rxjs.BehaviorSubject(0), []);
  const requestState$ = (0, _react.useMemo)(() => new _rxjs.BehaviorSubject(null), []);
  (0, _react.useEffect)(() => {
    updateSearchSessionId();
  }, [updateSearchSessionId]);
  const waitUntilRequestsCompletes$ = (0, _react.useCallback)(() => requestsCount$.pipe((0, _rxjs.distinctUntilChanged)(),
  // Skip values emitted by subject$ until the first state equals 0.
  (0, _rxjs.skipUntil)(requestsCount$.pipe((0, _rxjs.first)(state => state === 0))),
  // Wait for a specified period of idle time before emitting a value.
  (0, _rxjs.debounceTime)(WAIT_MS),
  // Emit the first value where state equals 0.
  (0, _rxjs.first)(state => state === 0)), [requestsCount$]);
  const isAutoRefreshEnabled$ = (0, _react.useCallback)(() => autoRefreshConfig$.pipe((0, _rxjs.first)(config => {
    return !!config && config.isPaused !== true;
  })), [autoRefreshConfig$]);
  (0, _react.useEffect)(() => {
    // Subscribe to updates in the request state
    const requestStateSubscription = requestState$.pipe((0, _rxjs.filter)(status => !!status), (0, _rxjs.map)(status => ['error', 'done'].includes(status) ? -1 : 1), (0, _rxjs.tap)(value => {
      // Update the number of running requests
      // NOTE: We could use the http.getLoadingCount$ instead, to count the number of HTTP requests.
      // However, it would consider the whole page, and here we're limiting the scope to the http requests that happen in the Asset Details context.
      requestsCount$.next(requestsCount$.getValue() + value);
    }),
    // Concatenate with loadingCounter$ observable
    (0, _rxjs.switchMap)(() => requestsCount$.pipe((0, _rxjs.distinctUntilChanged)(), (0, _rxjs.skipUntil)(isAutoRefreshEnabled$()), (0, _rxjs.switchMap)(runningRequestsCount => (0, _rxjs.of)(runningRequestsCount).pipe((0, _rxjs.withLatestFrom)(autoRefreshConfig$),
    // Small window for requests to be considered in the auto-refresh cycle
    (0, _rxjs.debounce)(([, config]) => {
      var _config$interval;
      return (0, _rxjs.interval)(((_config$interval = config === null || config === void 0 ? void 0 : config.interval) !== null && _config$interval !== void 0 ? _config$interval : WAIT_MS) / 2);
    }), (0, _rxjs.tap)(([count]) => {
      if (count > 0) {
        // isAutoRefreshRequestPending$.next is only set to false in the autoRefreshTick$ subscription
        // which will allow us to control when new requests can be made.
        isAutoRefreshRequestPending$.next(true);
      }
    })))))).subscribe();

    // Subscribe to autoRefreshTick$ observable
    const autoRefreshTickSubscription = (0, _rxjs.merge)(autoRefreshTick$.pipe((0, _rxjs.skipUntil)(isAutoRefreshEnabled$()), (0, _rxjs.withLatestFrom)(requestsCount$), (0, _rxjs.switchMap)(([, count]) => {
      // Any request called using `use_request_observable` will fall into this case
      // If there are still pending requests
      if (count > 0) {
        // Wait until requests complete before processing the next tick
        return waitUntilRequestsCompletes$().pipe((0, _rxjs.tap)(() => isAutoRefreshRequestPending$.next(false)));
      }
      // Else immediately emit false if the counter is already 0
      return (0, _rxjs.of)(null).pipe((0, _rxjs.tap)(() => {
        isAutoRefreshRequestPending$.next(false);
      }));
    })), autoRefreshTick$.pipe((0, _rxjs.skipUntil)(isAutoRefreshEnabled$()), (0, _rxjs.withLatestFrom)(search.session.state$, isAutoRefreshRequestPending$), (0, _rxjs.switchMap)(([_, state, isAutoRefreshRequestPending]) => {
      // if the current state$ value is not Completed
      if (state === _public.SearchSessionState.Loading) {
        // Wait until queries using data.search complete before processing the next tick
        // This will only be called when Lens is used in the Asset Details page
        return (0, _public.waitUntilNextSessionCompletes$)(search.session).pipe((0, _rxjs.tap)(() => {
          updateSearchSessionId();
        }));
      }

      // Else immediately emit true if session state is already completed
      return (0, _rxjs.of)(null).pipe((0, _rxjs.tap)(() => {
        if (!isAutoRefreshRequestPending) {
          updateSearchSessionId();
        }
      }));
    }))).subscribe();
    return () => {
      requestStateSubscription.unsubscribe();
      autoRefreshTickSubscription.unsubscribe();
    };
  }, [autoRefreshConfig$, autoRefreshTick$, isAutoRefreshEnabled$, isAutoRefreshRequestPending$, requestState$, requestsCount$, search.session, updateSearchSessionId, waitUntilRequestsCompletes$]);
  return {
    requestState$,
    isAutoRefreshRequestPending$
  };
};
exports.useLoadingState = useLoadingState;
const [LoadingStateProvider, useLoadingStateContext] = (0, _constate.default)(useLoadingState);
exports.useLoadingStateContext = useLoadingStateContext;
exports.LoadingStateProvider = LoadingStateProvider;