"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useIntegrationCheck = void 0;
var _react = require("react");
var _use_metadata_state = require("./use_metadata_state");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useIntegrationCheck = ({
  dependsOn
}) => {
  const {
    metadata
  } = (0, _use_metadata_state.useMetadataStateContext)();
  const hasIntegration = (0, _react.useMemo)(() => {
    var _metadata$features;
    return ((_metadata$features = metadata === null || metadata === void 0 ? void 0 : metadata.features) !== null && _metadata$features !== void 0 ? _metadata$features : []).some(f => f.name.startsWith(dependsOn));
  }, [metadata === null || metadata === void 0 ? void 0 : metadata.features, dependsOn]);
  return hasIntegration;
};
exports.useIntegrationCheck = useIntegrationCheck;