"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useEntitySummary = useEntitySummary;
var z = _interopRequireWildcard(require("@kbn/zod"));
var _common = require("@kbn/observability-shared-plugin/common");
var _use_fetcher = require("../../../hooks/use_fetcher");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EntityTypeSchema = z.union([z.literal(_common.EntityType.HOST), z.literal(_common.EntityType.CONTAINER)]);
const EntityDataStreamSchema = z.union([z.literal(_common.EntityDataStreamType.METRICS), z.literal(_common.EntityDataStreamType.LOGS)]);
const EntitySummarySchema = z.object({
  entityType: EntityTypeSchema,
  entityId: z.string(),
  sourceDataStreams: z.array(EntityDataStreamSchema)
});
function useEntitySummary({
  entityType,
  entityId
}) {
  var _data$sourceDataStrea;
  const {
    data,
    status
  } = (0, _use_fetcher.useFetcher)(async callApi => {
    if (!entityType || !entityId) {
      return undefined;
    }
    const response = await callApi(`/api/infra/entities/${entityType}/${entityId}/summary`, {
      method: 'GET'
    });
    return EntitySummarySchema.parse(response);
  }, [entityType, entityId]);
  return {
    dataStreams: (_data$sourceDataStrea = data === null || data === void 0 ? void 0 : data.sourceDataStreams) !== null && _data$sourceDataStrea !== void 0 ? _data$sourceDataStrea : [],
    status
  };
}