"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Content = void 0;
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _react = _interopRequireDefault(require("react"));
var _date_picker = require("../date_picker/date_picker");
var _use_tab_switcher = require("../hooks/use_tab_switcher");
var _tabs = require("../tabs");
var _types = require("../types");
var _callouts = require("./callouts");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Content = () => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_callouts.Callouts, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(DatePickerWrapper, {
    visibleFor: [_types.ContentTabIds.OVERVIEW, _types.ContentTabIds.LOGS, _types.ContentTabIds.METADATA, _types.ContentTabIds.METRICS, _types.ContentTabIds.PROCESSES, _types.ContentTabIds.ANOMALIES, _types.ContentTabIds.DASHBOARDS]
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(TabPanel, {
    activeWhen: _types.ContentTabIds.ANOMALIES
  }, /*#__PURE__*/_react.default.createElement(_tabs.Anomalies, null)), /*#__PURE__*/_react.default.createElement(TabPanel, {
    activeWhen: _types.ContentTabIds.OVERVIEW
  }, /*#__PURE__*/_react.default.createElement(_tabs.Overview, null)), /*#__PURE__*/_react.default.createElement(TabPanel, {
    activeWhen: _types.ContentTabIds.LOGS
  }, /*#__PURE__*/_react.default.createElement(_tabs.Logs, null)), /*#__PURE__*/_react.default.createElement(TabPanel, {
    activeWhen: _types.ContentTabIds.METADATA
  }, /*#__PURE__*/_react.default.createElement(_tabs.Metadata, null)), /*#__PURE__*/_react.default.createElement(TabPanel, {
    activeWhen: _types.ContentTabIds.METRICS
  }, /*#__PURE__*/_react.default.createElement(_tabs.Metrics, null)), /*#__PURE__*/_react.default.createElement(TabPanel, {
    activeWhen: _types.ContentTabIds.OSQUERY
  }, /*#__PURE__*/_react.default.createElement(_tabs.Osquery, null)), /*#__PURE__*/_react.default.createElement(TabPanel, {
    activeWhen: _types.ContentTabIds.PROCESSES
  }, /*#__PURE__*/_react.default.createElement(_tabs.Processes, null)), /*#__PURE__*/_react.default.createElement(TabPanel, {
    activeWhen: _types.ContentTabIds.PROFILING
  }, /*#__PURE__*/_react.default.createElement(_tabs.Profiling, null)), /*#__PURE__*/_react.default.createElement(TabPanel, {
    activeWhen: _types.ContentTabIds.DASHBOARDS
  }, /*#__PURE__*/_react.default.createElement(_tabs.Dashboards, null))));
};
exports.Content = Content;
const DatePickerWrapper = ({
  visibleFor
}) => {
  const {
    activeTabId
  } = (0, _use_tab_switcher.useTabSwitcherContext)();
  return /*#__PURE__*/_react.default.createElement("div", {
    hidden: !visibleFor.includes(activeTabId)
  }, /*#__PURE__*/_react.default.createElement(_date_picker.DatePicker, null));
};
const TabPanel = ({
  activeWhen,
  children
}) => {
  const {
    renderedTabsSet,
    activeTabId
  } = (0, _use_tab_switcher.useTabSwitcherContext)();
  return renderedTabsSet.current.has(activeWhen) ? /*#__PURE__*/_react.default.createElement("div", {
    hidden: activeTabId !== activeWhen,
    "data-test-subj": `infraAssetDetails${(0, _lodash.capitalize)(activeWhen)}TabContent`
  }, children) : null;
};