"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TitleWithTooltip = exports.SectionTitle = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _popover = require("../tabs/common/popover");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SectionTitle = ({
  title,
  'data-test-subj': dataTestSubject
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs",
    "data-test-subj": dataTestSubject
  }, /*#__PURE__*/_react.default.createElement("span", null, title));
};
exports.SectionTitle = SectionTitle;
const TitleWithTooltip = ({
  title,
  'data-test-subj': dataTestSubject,
  tooltipTestSubj,
  tooltipContent
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    alignItems: "center",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(SectionTitle, {
    title: title,
    "data-test-subj": dataTestSubject
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_popover.Popover, {
    icon: "iInCircle",
    "data-test-subj": tooltipTestSubj
  }, tooltipContent)));
};
exports.TitleWithTooltip = TitleWithTooltip;