"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createMetricThresholdRuleType = createMetricThresholdRuleType;
var _i18n = require("@kbn/i18n");
var _react = require("react");
var _metrics = require("../../../common/alerting/metrics");
var _validation = require("./components/validation");
var _rule_data_formatters = require("./rule_data_formatters");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const metricThresholdDefaultActionMessage = _i18n.i18n.translate('xpack.infra.metrics.alerting.metric.threshold.defaultActionMessage', {
  defaultMessage: `'{{context.reason}}'

'{{rule.name}}' is active with the following conditions:

- Affected: '{{context.group}}'
- Metric: '{{context.metric}}'
- Observed value: '{{context.value}}'
- Threshold: '{{context.threshold}}'

[View alert details]('{{context.alertDetailsUrl}}')
`
});
const metricThresholdDefaultRecoveryMessage = _i18n.i18n.translate('xpack.infra.metrics.alerting.metric.threshold.defaultRecoveryMessage', {
  defaultMessage: `'{{rule.name}}' has recovered.

- Affected: '{{context.group}}'
- Metric: '{{context.metric}}'
- Threshold: '{{context.threshold}}'

[View alert details]('{{context.alertDetailsUrl}}')
`
});
function createMetricThresholdRuleType({
  assetDetailsLocator,
  metricsExplorerLocator
}) {
  return {
    id: _metrics.METRIC_THRESHOLD_ALERT_TYPE_ID,
    description: _i18n.i18n.translate('xpack.infra.metrics.alertFlyout.alertDescription', {
      defaultMessage: 'Alert when the metrics aggregation exceeds the threshold.'
    }),
    iconClass: 'bell',
    documentationUrl(docLinks) {
      return `${docLinks.links.observability.metricsThreshold}`;
    },
    ruleParamsExpression: /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./components/expression')))),
    validate: _validation.validateMetricThreshold,
    defaultActionMessage: metricThresholdDefaultActionMessage,
    defaultRecoveryMessage: metricThresholdDefaultRecoveryMessage,
    requiresAppContext: false,
    format: (0, _rule_data_formatters.getRuleFormat)({
      assetDetailsLocator,
      metricsExplorerLocator
    }),
    alertDetailsAppSection: /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./components/alert_details_app_section')))),
    priority: 10
  };
}