"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertFlyout = AlertFlyout;
var _react = require("react");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _triggers_actions_context = require("../../../containers/triggers_actions_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function AlertFlyout({
  onClose
}) {
  const {
    triggersActionsUI
  } = (0, _react.useContext)(_triggers_actions_context.TriggerActionsContext);
  const addAlertFlyout = (0, _react.useMemo)(() => {
    if (!triggersActionsUI) {
      return null;
    }
    return triggersActionsUI.getAddRuleFlyout({
      consumer: 'infrastructure',
      onClose,
      canChangeTrigger: false,
      ruleTypeId: _ruleDataUtils.OBSERVABILITY_THRESHOLD_RULE_TYPE_ID,
      metadata: {
        currentOptions: {
          /*
          Setting the groupBy is currently required in custom threshold
          rule for it to populate the rule with additional host context.
          */
          groupBy: 'host.name'
        }
      }
    });
  }, [onClose, triggersActionsUI]);
  return addAlertFlyout;
}