"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InfraUpdateCustomDashboardsRequestPathParamsRT = exports.InfraSaveCustomDashboardsResponseBodyRT = exports.InfraSaveCustomDashboardsRequestPayloadRT = exports.InfraGetCustomDashboardsResponseBodyRT = exports.InfraGetCustomDashboardsRequestPathParamsRT = exports.InfraDeleteCustomDashboardsResponseBodyRT = exports.InfraDeleteCustomDashboardsRequestParamsRT = exports.InfraCustomDashboardRT = void 0;
var _common = require("@kbn/metrics-data-access-plugin/common");
var rt = _interopRequireWildcard(require("io-ts"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AssetTypeRT = rt.type({
  assetType: _common.ItemTypeRT
});
const PayloadRT = rt.type({
  dashboardSavedObjectId: rt.string,
  dashboardFilterAssetIdEnabled: rt.boolean
});
const SavedObjectIdRT = rt.type({
  id: rt.string
});
const InfraCustomDashboardRT = exports.InfraCustomDashboardRT = rt.intersection([AssetTypeRT, PayloadRT, SavedObjectIdRT]);

/**
 GET endpoint
*/
const InfraGetCustomDashboardsRequestPathParamsRT = exports.InfraGetCustomDashboardsRequestPathParamsRT = AssetTypeRT;
const InfraGetCustomDashboardsResponseBodyRT = exports.InfraGetCustomDashboardsResponseBodyRT = rt.array(InfraCustomDashboardRT);
/**
 * POST endpoint
 */
const InfraSaveCustomDashboardsRequestPayloadRT = exports.InfraSaveCustomDashboardsRequestPayloadRT = PayloadRT;
const InfraSaveCustomDashboardsResponseBodyRT = exports.InfraSaveCustomDashboardsResponseBodyRT = InfraCustomDashboardRT;
/**
 * PUT endpoint
 */
const InfraUpdateCustomDashboardsRequestPathParamsRT = exports.InfraUpdateCustomDashboardsRequestPathParamsRT = rt.intersection([AssetTypeRT, SavedObjectIdRT]);

/**
 * DELETE endpoint
 */
const InfraDeleteCustomDashboardsRequestParamsRT = exports.InfraDeleteCustomDashboardsRequestParamsRT = rt.intersection([AssetTypeRT, SavedObjectIdRT]);
const InfraDeleteCustomDashboardsResponseBodyRT = exports.InfraDeleteCustomDashboardsResponseBodyRT = rt.string;