"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fifteenMinutesInMilliseconds = exports.TIMESTAMP_FIELD = exports.TIEBREAKER_FIELD = exports.SYSTEM_INTEGRATION = exports.SNAPSHOT_API_MAX_METRICS = exports.PROCESS_COMMANDLINE_FIELD = exports.O11Y_AAD_FIELDS = exports.METRICS_INDEX_PATTERN = exports.METRICS_FEATURE_ID = exports.METRICS_APP = exports.METRICSET_NAME = exports.METRICSET_MODULE = exports.MESSAGE_FIELD = exports.LOGS_INDEX_PATTERN = exports.LOGS_FEATURE_ID = exports.LOGS_APP = exports.KUBERNETES_POD_UID_FIELD = exports.INFRA_ALERT_FEATURE_ID = exports.HOST_NAME_FIELD = exports.EVENT_MODULE = exports.DEFAULT_METRICS_VIEW_ATTRIBUTES = exports.CONTAINER_ID_FIELD = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const METRICS_INDEX_PATTERN = exports.METRICS_INDEX_PATTERN = 'metrics-*,metricbeat-*';
const LOGS_INDEX_PATTERN = exports.LOGS_INDEX_PATTERN = 'logs-*,filebeat-*,kibana_sample_data_logs*';
const METRICS_APP = exports.METRICS_APP = 'metrics';
const LOGS_APP = exports.LOGS_APP = 'logs';
const METRICS_FEATURE_ID = exports.METRICS_FEATURE_ID = 'infrastructure';
const INFRA_ALERT_FEATURE_ID = exports.INFRA_ALERT_FEATURE_ID = 'infrastructure';
const LOGS_FEATURE_ID = exports.LOGS_FEATURE_ID = 'logs';
const TIMESTAMP_FIELD = exports.TIMESTAMP_FIELD = '@timestamp';
const TIEBREAKER_FIELD = exports.TIEBREAKER_FIELD = '_doc';

// system
const HOST_NAME_FIELD = exports.HOST_NAME_FIELD = 'host.name';
const CONTAINER_ID_FIELD = exports.CONTAINER_ID_FIELD = 'container.id';
const KUBERNETES_POD_UID_FIELD = exports.KUBERNETES_POD_UID_FIELD = 'kubernetes.pod.uid';
const PROCESS_COMMANDLINE_FIELD = exports.PROCESS_COMMANDLINE_FIELD = 'process.command_line';
const EVENT_MODULE = exports.EVENT_MODULE = 'event.module';
const METRICSET_MODULE = exports.METRICSET_MODULE = 'metricset.module';
const METRICSET_NAME = exports.METRICSET_NAME = 'metricset.name';

// integrations
const SYSTEM_INTEGRATION = exports.SYSTEM_INTEGRATION = 'system';

// logs
const MESSAGE_FIELD = exports.MESSAGE_FIELD = 'message';
const O11Y_AAD_FIELDS = exports.O11Y_AAD_FIELDS = ['cloud.*', 'host.*', 'orchestrator.*', 'container.*', 'labels.*', 'tags'];
const fifteenMinutesInMilliseconds = exports.fifteenMinutesInMilliseconds = 15 * 60 * 1000;
const DEFAULT_METRICS_VIEW_ATTRIBUTES = exports.DEFAULT_METRICS_VIEW_ATTRIBUTES = {
  name: 'Metrics View',
  timeFieldName: TIMESTAMP_FIELD
};
const SNAPSHOT_API_MAX_METRICS = exports.SNAPSHOT_API_MAX_METRICS = 20;