"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.QUERY_INVALID = exports.METRIC_THRESHOLD_ALERT_TYPE_ID = exports.METRIC_INVENTORY_THRESHOLD_ALERT_TYPE_ID = exports.InfraRuleType = exports.AlertStates = exports.Aggregators = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const METRIC_THRESHOLD_ALERT_TYPE_ID = exports.METRIC_THRESHOLD_ALERT_TYPE_ID = 'metrics.alert.threshold';
const METRIC_INVENTORY_THRESHOLD_ALERT_TYPE_ID = exports.METRIC_INVENTORY_THRESHOLD_ALERT_TYPE_ID = 'metrics.alert.inventory.threshold';
let InfraRuleType = exports.InfraRuleType = /*#__PURE__*/function (InfraRuleType) {
  InfraRuleType["MetricThreshold"] = "metrics.alert.threshold";
  InfraRuleType["InventoryThreshold"] = "metrics.alert.inventory.threshold";
  return InfraRuleType;
}({});
let Aggregators = exports.Aggregators = /*#__PURE__*/function (Aggregators) {
  Aggregators["COUNT"] = "count";
  Aggregators["AVERAGE"] = "avg";
  Aggregators["SUM"] = "sum";
  Aggregators["MIN"] = "min";
  Aggregators["MAX"] = "max";
  Aggregators["RATE"] = "rate";
  Aggregators["CARDINALITY"] = "cardinality";
  Aggregators["P95"] = "p95";
  Aggregators["P99"] = "p99";
  Aggregators["CUSTOM"] = "custom";
  return Aggregators;
}({});
let AlertStates = exports.AlertStates = /*#__PURE__*/function (AlertStates) {
  AlertStates[AlertStates["OK"] = 0] = "OK";
  AlertStates[AlertStates["ALERT"] = 1] = "ALERT";
  AlertStates[AlertStates["WARNING"] = 2] = "WARNING";
  AlertStates[AlertStates["NO_DATA"] = 3] = "NO_DATA";
  AlertStates[AlertStates["ERROR"] = 4] = "ERROR";
  return AlertStates;
}({}); // Types for the executor
const QUERY_INVALID = exports.QUERY_INVALID = Symbol('QUERY_INVALID');