"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getConnectorById = void 0;
var _connectors = require("../../common/connectors");
var _errors = require("../../common/errors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Retrieves a connector given the provided `connectorId` and asserts it's an inference connector
 */
const getConnectorById = async ({
  connectorId,
  actionsClient
}) => {
  let connector;
  try {
    connector = await actionsClient.get({
      id: connectorId,
      throwIfSystemAction: true
    });
  } catch (error) {
    throw (0, _errors.createInferenceRequestError)(`No connector found for id '${connectorId}'`, 400);
  }
  const actionTypeId = connector.actionTypeId;
  if (!(0, _connectors.isSupportedConnectorType)(actionTypeId)) {
    throw (0, _errors.createInferenceRequestError)(`Type '${actionTypeId}' not recognized as a supported connector type`, 400);
  }
  return {
    connectorId: connector.id,
    name: connector.name,
    type: actionTypeId
  };
};
exports.getConnectorById = getConnectorById;