"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.naturalLanguageToEsql = naturalLanguageToEsql;
var _lodash = require("lodash");
var _rxjs = require("rxjs");
var _chat_complete = require("../../../common/chat_complete");
var _doc_base = require("./doc_base");
var _actions = require("./actions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const loadDocBase = (0, _lodash.once)(() => _doc_base.EsqlDocumentBase.load());
function naturalLanguageToEsql({
  client,
  connectorId,
  tools,
  toolChoice,
  logger,
  functionCalling,
  ...rest
}) {
  return (0, _rxjs.from)(loadDocBase()).pipe((0, _rxjs.switchMap)(docBase => {
    const systemMessage = docBase.getSystemMessage();
    const messages = 'input' in rest ? [{
      role: _chat_complete.MessageRole.User,
      content: rest.input
    }] : rest.messages;
    const askLlmToRespond = (0, _actions.generateEsqlTask)({
      connectorId,
      chatCompleteApi: client.chatComplete,
      messages,
      docBase,
      logger,
      systemMessage,
      functionCalling,
      toolOptions: {
        tools,
        toolChoice
      }
    });
    return (0, _actions.requestDocumentation)({
      connectorId,
      functionCalling,
      outputApi: client.output,
      messages,
      system: systemMessage,
      toolOptions: {
        tools,
        toolChoice
      }
    }).pipe((0, _rxjs.switchMap)(documentationEvent => {
      return askLlmToRespond({
        documentationRequest: {
          commands: documentationEvent.output.commands,
          functions: documentationEvent.output.functions
        }
      });
    }));
  }));
}