"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerChatCompleteRoute = registerChatCompleteRoute;
var _configSchema = require("@kbn/config-schema");
var _chat_complete = require("../../common/chat_complete");
var _tools = require("../../common/chat_complete/tools");
var _inference_client = require("../inference_client");
var _observable_into_event_source_stream = require("../util/observable_into_event_source_stream");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const toolCallSchema = _configSchema.schema.arrayOf(_configSchema.schema.object({
  toolCallId: _configSchema.schema.string(),
  function: _configSchema.schema.object({
    name: _configSchema.schema.string(),
    arguments: _configSchema.schema.maybe(_configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.any()))
  })
}));
const chatCompleteBodySchema = _configSchema.schema.object({
  connectorId: _configSchema.schema.string(),
  system: _configSchema.schema.maybe(_configSchema.schema.string()),
  tools: _configSchema.schema.maybe(_configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.object({
    description: _configSchema.schema.string(),
    schema: _configSchema.schema.maybe(_configSchema.schema.object({
      type: _configSchema.schema.literal('object'),
      properties: _configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.any()),
      required: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string()))
    }))
  }))),
  toolChoice: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal(_tools.ToolChoiceType.auto), _configSchema.schema.literal(_tools.ToolChoiceType.none), _configSchema.schema.literal(_tools.ToolChoiceType.required), _configSchema.schema.object({
    function: _configSchema.schema.string()
  })])),
  messages: _configSchema.schema.arrayOf(_configSchema.schema.oneOf([_configSchema.schema.object({
    role: _configSchema.schema.literal(_chat_complete.MessageRole.Assistant),
    content: _configSchema.schema.oneOf([_configSchema.schema.string(), _configSchema.schema.literal(null)]),
    toolCalls: _configSchema.schema.maybe(toolCallSchema)
  }), _configSchema.schema.object({
    role: _configSchema.schema.literal(_chat_complete.MessageRole.User),
    content: _configSchema.schema.string(),
    name: _configSchema.schema.maybe(_configSchema.schema.string())
  }), _configSchema.schema.object({
    role: _configSchema.schema.literal(_chat_complete.MessageRole.Tool),
    toolCallId: _configSchema.schema.string(),
    response: _configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.any())
  })])),
  functionCalling: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal('native'), _configSchema.schema.literal('simulated')]))
});
function registerChatCompleteRoute({
  coreSetup,
  router,
  logger
}) {
  router.post({
    path: '/internal/inference/chat_complete',
    validate: {
      body: chatCompleteBodySchema
    }
  }, async (context, request, response) => {
    const actions = await coreSetup.getStartServices().then(([coreStart, pluginsStart]) => pluginsStart.actions);
    const client = (0, _inference_client.createInferenceClient)({
      request,
      actions,
      logger
    });
    const {
      connectorId,
      messages,
      system,
      toolChoice,
      tools,
      functionCalling
    } = request.body;
    const chatCompleteResponse = client.chatComplete({
      connectorId,
      messages,
      system,
      toolChoice,
      tools,
      functionCalling
    });
    return response.ok({
      body: (0, _observable_into_event_source_stream.observableIntoEventSourceStream)(chatCompleteResponse, logger)
    });
  });
}