"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InferencePlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _inference_client = require("./inference_client");
var _routes = require("./routes");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class InferencePlugin {
  constructor(context) {
    (0, _defineProperty2.default)(this, "logger", void 0);
    this.logger = context.logger.get();
  }
  setup(coreSetup, pluginsSetup) {
    const router = coreSetup.http.createRouter();
    (0, _routes.registerRoutes)({
      router,
      coreSetup,
      logger: this.logger
    });
    return {};
  }
  start(core, pluginsStart) {
    return {
      getClient: ({
        request
      }) => {
        return (0, _inference_client.createInferenceClient)({
          request,
          actions: pluginsStart.actions,
          logger: this.logger.get('client')
        });
      }
    };
  }
}
exports.InferencePlugin = InferencePlugin;