"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createInferenceExecutor = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Represent the actual interface to communicate with the inference model.
 *
 * In practice, for now it's just a thin abstraction around the action client.
 */

const createInferenceExecutor = ({
  connector,
  actionsClient
}) => {
  return {
    async invoke({
      subAction,
      subActionParams
    }) {
      return await actionsClient.execute({
        actionId: connector.connectorId,
        params: {
          subAction,
          subActionParams
        }
      });
    }
  };
};
exports.createInferenceExecutor = createInferenceExecutor;