"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.chunksIntoMessage = chunksIntoMessage;
var _rxjs = require("rxjs");
var _chat_complete = require("../../../common/chat_complete");
var _without_token_count_events = require("../../../common/chat_complete/without_token_count_events");
var _validate_tool_calls = require("../../util/validate_tool_calls");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function chunksIntoMessage({
  logger,
  toolOptions
}) {
  return chunks$ => {
    const shared$ = chunks$.pipe((0, _rxjs.share)());
    return (0, _rxjs.merge)(shared$, shared$.pipe((0, _without_token_count_events.withoutTokenCountEvents)(), (0, _rxjs.scan)((prev, chunk) => {
      var _chunk$content, _chunk$tool_calls;
      prev.content += (_chunk$content = chunk.content) !== null && _chunk$content !== void 0 ? _chunk$content : '';
      (_chunk$tool_calls = chunk.tool_calls) === null || _chunk$tool_calls === void 0 ? void 0 : _chunk$tool_calls.forEach(toolCall => {
        let prevToolCall = prev.tool_calls[toolCall.index];
        if (!prevToolCall) {
          prev.tool_calls[toolCall.index] = {
            function: {
              name: '',
              arguments: ''
            },
            toolCallId: ''
          };
          prevToolCall = prev.tool_calls[toolCall.index];
        }
        prevToolCall.function.name += toolCall.function.name;
        prevToolCall.function.arguments += toolCall.function.arguments;
        prevToolCall.toolCallId += toolCall.toolCallId;
      });
      return prev;
    }, {
      content: '',
      tool_calls: []
    }), (0, _rxjs.last)(), (0, _rxjs.map)(concatenatedChunk => {
      logger.debug(() => `Received completed message: ${JSON.stringify(concatenatedChunk)}`);
      const validatedToolCalls = (0, _validate_tool_calls.validateToolCalls)({
        ...toolOptions,
        toolCalls: concatenatedChunk.tool_calls
      });
      return {
        type: _chat_complete.ChatCompletionEventType.ChatCompletionMessage,
        content: concatenatedChunk.content,
        toolCalls: validatedToolCalls
      };
    })));
  };
}