"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createChatCompleteApi = createChatCompleteApi;
var _lodash = require("lodash");
var _rxjs = require("rxjs");
var _errors = require("../../common/errors");
var _get_connector_by_id = require("../util/get_connector_by_id");
var _adapters = require("./adapters");
var _utils = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function createChatCompleteApi({
  request,
  actions,
  logger
}) {
  const chatCompleteAPI = ({
    connectorId,
    messages,
    toolChoice,
    tools,
    system,
    functionCalling
  }) => {
    return (0, _rxjs.defer)(async () => {
      const actionsClient = await actions.getActionsClientWithRequest(request);
      const connector = await (0, _get_connector_by_id.getConnectorById)({
        connectorId,
        actionsClient
      });
      const executor = (0, _utils.createInferenceExecutor)({
        actionsClient,
        connector
      });
      return {
        executor,
        connector
      };
    }).pipe((0, _rxjs.switchMap)(({
      executor,
      connector
    }) => {
      const connectorType = connector.type;
      const inferenceAdapter = (0, _adapters.getInferenceAdapter)(connectorType);
      if (!inferenceAdapter) {
        return (0, _rxjs.throwError)(() => (0, _errors.createInferenceRequestError)(`Adapter for type ${connectorType} not implemented`, 400));
      }
      logger.debug(() => `Sending request: ${JSON.stringify((0, _lodash.last)(messages))}`);
      logger.trace(() => JSON.stringify({
        messages,
        toolChoice,
        tools,
        system
      }));
      return inferenceAdapter.chatComplete({
        system,
        executor,
        messages,
        toolChoice,
        tools,
        logger,
        functionCalling
      });
    }), (0, _utils.chunksIntoMessage)({
      toolOptions: {
        toolChoice,
        tools
      },
      logger
    }));
  };
  return chatCompleteAPI;
}