"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getInferenceAdapter = void 0;
var _connectors = require("../../../common/connectors");
var _openai = require("./openai");
var _gemini = require("./gemini");
var _bedrock = require("./bedrock");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getInferenceAdapter = connectorType => {
  switch (connectorType) {
    case _connectors.InferenceConnectorType.OpenAI:
      return _openai.openAIAdapter;
    case _connectors.InferenceConnectorType.Gemini:
      return _gemini.geminiAdapter;
    case _connectors.InferenceConnectorType.Bedrock:
      return _bedrock.bedrockClaudeAdapter;
  }
  return undefined;
};
exports.getInferenceAdapter = getInferenceAdapter;