"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.processVertexStream = processVertexStream;
var _rxjs = require("rxjs");
var _chat_complete = require("../../../../common/chat_complete");
var _common = require("../../../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function processVertexStream() {
  return source => new _rxjs.Observable(subscriber => {
    function handleNext(value) {
      var _value$candidates;
      // completion: only present on last chunk
      if (value.usageMetadata) {
        subscriber.next({
          type: _chat_complete.ChatCompletionEventType.ChatCompletionTokenCount,
          tokens: {
            prompt: value.usageMetadata.promptTokenCount,
            completion: value.usageMetadata.candidatesTokenCount,
            total: value.usageMetadata.totalTokenCount
          }
        });
      }
      const contentPart = (_value$candidates = value.candidates) === null || _value$candidates === void 0 ? void 0 : _value$candidates[0].content.parts[0];
      const completion = contentPart === null || contentPart === void 0 ? void 0 : contentPart.text;
      const toolCall = contentPart === null || contentPart === void 0 ? void 0 : contentPart.functionCall;
      if (completion || toolCall) {
        subscriber.next({
          type: _chat_complete.ChatCompletionEventType.ChatCompletionChunk,
          content: completion !== null && completion !== void 0 ? completion : '',
          tool_calls: toolCall ? [{
            index: 0,
            toolCallId: (0, _common.generateFakeToolCallId)(),
            function: {
              name: toolCall.name,
              arguments: JSON.stringify(toolCall.args)
            }
          }] : []
        });
      }
    }
    source.subscribe({
      next: value => {
        try {
          handleNext(value);
        } catch (error) {
          subscriber.error(error);
        }
      },
      error: err => {
        subscriber.error(err);
      },
      complete: () => {
        subscriber.complete();
      }
    });
  });
}