"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.geminiAdapter = void 0;
var Gemini = _interopRequireWildcard(require("@google/generative-ai"));
var _rxjs = require("rxjs");
var _chat_complete = require("../../../../common/chat_complete");
var _tools = require("../../../../common/chat_complete/tools");
var _event_source_stream_into_observable = require("../../../util/event_source_stream_into_observable");
var _process_vertex_stream = require("./process_vertex_stream");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const geminiAdapter = exports.geminiAdapter = {
  chatComplete: ({
    executor,
    system,
    messages,
    toolChoice,
    tools
  }) => {
    return (0, _rxjs.from)(executor.invoke({
      subAction: 'invokeStream',
      subActionParams: {
        messages: messagesToGemini({
          messages
        }),
        systemInstruction: system,
        tools: toolsToGemini(tools),
        toolConfig: toolChoiceToConfig(toolChoice),
        temperature: 0,
        stopSequences: ['\n\nHuman:']
      }
    })).pipe((0, _rxjs.switchMap)(response => {
      const readable = response.data;
      return (0, _event_source_stream_into_observable.eventSourceStreamIntoObservable)(readable);
    }), (0, _rxjs.map)(line => {
      return JSON.parse(line);
    }), (0, _process_vertex_stream.processVertexStream)());
  }
};
function toolChoiceToConfig(toolChoice) {
  if (toolChoice === _tools.ToolChoiceType.required) {
    return {
      mode: 'ANY'
    };
  } else if (toolChoice === _tools.ToolChoiceType.none) {
    return {
      mode: 'NONE'
    };
  } else if (toolChoice === _tools.ToolChoiceType.auto) {
    return {
      mode: 'AUTO'
    };
  } else if (toolChoice) {
    return {
      mode: 'ANY',
      allowedFunctionNames: [toolChoice.function]
    };
  }
  return undefined;
}
function toolsToGemini(tools) {
  return tools ? [{
    functionDeclarations: Object.entries(tools !== null && tools !== void 0 ? tools : {}).map(([toolName, {
      description,
      schema
    }]) => {
      return {
        name: toolName,
        description,
        parameters: schema ? toolSchemaToGemini({
          schema
        }) : {
          type: Gemini.FunctionDeclarationSchemaType.OBJECT,
          properties: {}
        }
      };
    })
  }] : [];
}
function toolSchemaToGemini({
  schema
}) {
  var _schema$properties;
  const convertSchemaType = ({
    def
  }) => {
    switch (def.type) {
      case 'array':
        return {
          type: Gemini.FunctionDeclarationSchemaType.ARRAY,
          description: def.description,
          items: convertSchemaType({
            def: def.items
          })
        };
      case 'object':
        return {
          type: Gemini.FunctionDeclarationSchemaType.OBJECT,
          description: def.description,
          required: def.required,
          properties: def.properties ? Object.entries(def.properties).reduce((properties, [key, prop]) => {
            properties[key] = convertSchemaType({
              def: prop
            });
            return properties;
          }, {}) : undefined
        };
      case 'string':
        return {
          type: Gemini.FunctionDeclarationSchemaType.STRING,
          description: def.description,
          enum: def.enum ? def.enum : def.const ? [def.const] : undefined
        };
      case 'boolean':
        return {
          type: Gemini.FunctionDeclarationSchemaType.BOOLEAN,
          description: def.description,
          enum: def.enum ? def.enum : def.const ? [def.const] : undefined
        };
      case 'number':
        return {
          type: Gemini.FunctionDeclarationSchemaType.NUMBER,
          description: def.description,
          enum: def.enum ? def.enum : def.const ? [def.const] : undefined
        };
    }
  };
  return {
    type: Gemini.FunctionDeclarationSchemaType.OBJECT,
    required: schema.required,
    properties: Object.entries((_schema$properties = schema.properties) !== null && _schema$properties !== void 0 ? _schema$properties : {}).reduce((properties, [key, def]) => {
      properties[key] = convertSchemaType({
        def
      });
      return properties;
    }, {})
  };
}
function messagesToGemini({
  messages
}) {
  return messages.map(messageToGeminiMapper()).reduce((output, message) => {
    // merging consecutive messages from the same user, as Gemini requires multi-turn messages
    const previousMessage = output.length ? output[output.length - 1] : undefined;
    if ((previousMessage === null || previousMessage === void 0 ? void 0 : previousMessage.role) === message.role) {
      previousMessage.parts.push(...message.parts);
    } else {
      output.push(message);
    }
    return output;
  }, []);
}
function messageToGeminiMapper() {
  return message => {
    var _message$toolCalls;
    const role = message.role;
    switch (role) {
      case _chat_complete.MessageRole.Assistant:
        const assistantMessage = {
          role: 'assistant',
          parts: [...(message.content ? [{
            text: message.content
          }] : []), ...((_message$toolCalls = message.toolCalls) !== null && _message$toolCalls !== void 0 ? _message$toolCalls : []).map(toolCall => {
            return {
              functionCall: {
                name: toolCall.function.name,
                args: 'arguments' in toolCall.function ? toolCall.function.arguments : {}
              }
            };
          })]
        };
        return assistantMessage;
      case _chat_complete.MessageRole.User:
        const userMessage = {
          role: 'user',
          parts: [{
            text: message.content
          }]
        };
        return userMessage;
      case _chat_complete.MessageRole.Tool:
        // tool responses are provided as user messages
        const toolMessage = {
          role: 'user',
          parts: [{
            functionResponse: {
              name: message.toolCallId,
              response: message.response
            }
          }]
        };
        return toolMessage;
    }
  };
}