"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InferencePlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _create_output_api = require("../common/output/create_output_api");
var _chat_complete = require("./chat_complete");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class InferencePlugin {
  constructor(context) {
    (0, _defineProperty2.default)(this, "logger", void 0);
    this.logger = context.logger.get();
  }
  setup(coreSetup, pluginsSetup) {
    return {};
  }
  start(coreStart, pluginsStart) {
    const chatComplete = (0, _chat_complete.createChatCompleteApi)({
      http: coreStart.http
    });
    return {
      chatComplete,
      output: (0, _create_output_api.createOutputApi)(chatComplete),
      getConnectors: async () => {
        const res = await coreStart.http.get('/internal/inference/connectors');
        return res.connectors;
      }
    };
  }
}
exports.InferencePlugin = InferencePlugin;