"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createChatCompleteApi = createChatCompleteApi;
var _rxjs = require("rxjs");
var _http_response_into_observable = require("../util/http_response_into_observable");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function createChatCompleteApi({
  http
}) {
  return ({
    connectorId,
    messages,
    system,
    toolChoice,
    tools,
    functionCalling
  }) => {
    const body = {
      connectorId,
      system,
      messages,
      toolChoice,
      tools,
      functionCalling
    };
    return (0, _rxjs.from)(http.post('/internal/inference/chat_complete', {
      asResponse: true,
      rawResponse: true,
      body: JSON.stringify(body)
    })).pipe((0, _http_response_into_observable.httpResponseIntoObservable)());
  };
}