"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getErrorsWithCommands = getErrorsWithCommands;
var _correct_common_esql_mistakes = require("./correct_common_esql_mistakes");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getErrorsWithCommands(query, errors) {
  const asCommands = (0, _correct_common_esql_mistakes.splitIntoCommands)(query);
  const errorMessages = errors.map(error => {
    if ('location' in error) {
      const commandsUntilEndOfError = (0, _correct_common_esql_mistakes.splitIntoCommands)(query.substring(0, error.location.max));
      const lastCompleteCommand = asCommands[commandsUntilEndOfError.length - 1];
      if (lastCompleteCommand) {
        return `Error in \`| ${lastCompleteCommand.command}\`:\n ${error.text}`;
      }
    }
    return 'text' in error ? error.text : error.message;
  });
  return errorMessages;
}