"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OutputEventType = void 0;
exports.createOutputCompleteEvent = createOutputCompleteEvent;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let OutputEventType = exports.OutputEventType = /*#__PURE__*/function (OutputEventType) {
  OutputEventType["OutputUpdate"] = "output";
  OutputEventType["OutputComplete"] = "complete";
  return OutputEventType;
}({});
/**
 * Generate a response with the LLM for a prompt, optionally based on a schema.
 *
 * @param {string} id The id of the operation
 * @param {string} options.connectorId The ID of the connector that is to be used.
 * @param {string} options.input The prompt for the LLM.
 * @param {string} options.messages Previous messages in a conversation.
 * @param {ToolSchema} [options.schema] The schema the response from the LLM should adhere to.
 */
function createOutputCompleteEvent(id, output, content) {
  return {
    type: OutputEventType.OutputComplete,
    id,
    output,
    content: content !== null && content !== void 0 ? content : ''
  };
}