"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createOutputApi = createOutputApi;
var _rxjs = require("rxjs");
var _chat_complete = require("../chat_complete");
var _without_token_count_events = require("../chat_complete/without_token_count_events");
var _ = require(".");
var _ensure_multi_turn = require("../ensure_multi_turn");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function createOutputApi(chatCompleteApi) {
  return (id, {
    connectorId,
    input,
    schema,
    system,
    previousMessages,
    functionCalling
  }) => {
    return chatCompleteApi({
      connectorId,
      system,
      functionCalling,
      messages: (0, _ensure_multi_turn.ensureMultiTurn)([...(previousMessages || []), {
        role: _chat_complete.MessageRole.User,
        content: input
      }]),
      ...(schema ? {
        tools: {
          structuredOutput: {
            description: `Use the following schema to respond to the user's request in structured data, so it can be parsed and handled.`,
            schema
          }
        },
        toolChoice: {
          function: 'structuredOutput'
        }
      } : {})
    }).pipe((0, _without_token_count_events.withoutTokenCountEvents)(), (0, _rxjs.map)(event => {
      if (event.type === _chat_complete.ChatCompletionEventType.ChatCompletionChunk) {
        return {
          type: _.OutputEventType.OutputUpdate,
          id,
          content: event.content
        };
      }
      return {
        id,
        output: event.toolCalls.length && 'arguments' in event.toolCalls[0].function ? event.toolCalls[0].function.arguments : undefined,
        content: event.content,
        type: _.OutputEventType.OutputComplete
      };
    }));
  };
}