"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InferenceTaskErrorCode = exports.InferenceTaskError = void 0;
exports.createInferenceInternalError = createInferenceInternalError;
exports.createInferenceRequestError = createInferenceRequestError;
exports.isInferenceError = isInferenceError;
exports.isInferenceInternalError = isInferenceInternalError;
exports.isInferenceRequestError = isInferenceRequestError;
var _i18n = require("@kbn/i18n");
var _inference_task = require("./inference_task");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let InferenceTaskErrorCode = exports.InferenceTaskErrorCode = /*#__PURE__*/function (InferenceTaskErrorCode) {
  InferenceTaskErrorCode["internalError"] = "internalError";
  InferenceTaskErrorCode["requestError"] = "requestError";
  return InferenceTaskErrorCode;
}({});
class InferenceTaskError extends Error {
  constructor(code, message, meta) {
    super(message);
    this.code = code;
    this.meta = meta;
  }
  toJSON() {
    return {
      type: _inference_task.InferenceTaskEventType.error,
      error: {
        code: this.code,
        message: this.message,
        meta: this.meta
      }
    };
  }
}
exports.InferenceTaskError = InferenceTaskError;
function createInferenceInternalError(message = _i18n.i18n.translate('xpack.inference.internalError', {
  defaultMessage: 'An internal error occurred'
}), meta) {
  return new InferenceTaskError(InferenceTaskErrorCode.internalError, message, meta !== null && meta !== void 0 ? meta : {});
}
function createInferenceRequestError(message, status) {
  return new InferenceTaskError(InferenceTaskErrorCode.requestError, message, {
    status
  });
}
function isInferenceError(error) {
  return error instanceof InferenceTaskError;
}
function isInferenceInternalError(error) {
  return isInferenceError(error) && error.code === InferenceTaskErrorCode.internalError;
}
function isInferenceRequestError(error) {
  return isInferenceError(error) && error.code === InferenceTaskErrorCode.requestError;
}