"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ensureMultiTurn = ensureMultiTurn;
var _chat_complete = require("./chat_complete");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function isUserMessage(message) {
  return message.role !== _chat_complete.MessageRole.Assistant;
}
function ensureMultiTurn(messages) {
  const next = [];
  messages.forEach(message => {
    const prevMessage = next[next.length - 1];
    if (prevMessage && isUserMessage(prevMessage) === isUserMessage(message)) {
      next.push({
        content: '-',
        role: isUserMessage(message) ? _chat_complete.MessageRole.Assistant : _chat_complete.MessageRole.User
      });
    }
    next.push(message);
  });
  return next;
}