"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InferenceConnectorType = void 0;
exports.isSupportedConnectorType = isSupportedConnectorType;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let InferenceConnectorType = exports.InferenceConnectorType = /*#__PURE__*/function (InferenceConnectorType) {
  InferenceConnectorType["OpenAI"] = ".gen-ai";
  InferenceConnectorType["Bedrock"] = ".bedrock";
  InferenceConnectorType["Gemini"] = ".gemini";
  return InferenceConnectorType;
}({});
const allSupportedConnectorTypes = Object.values(InferenceConnectorType);
function isSupportedConnectorType(id) {
  return allSupportedConnectorTypes.includes(id);
}