"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MessageRole = exports.ChatCompletionEventType = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let MessageRole = exports.MessageRole = /*#__PURE__*/function (MessageRole) {
  MessageRole["User"] = "user";
  MessageRole["Assistant"] = "assistant";
  MessageRole["Tool"] = "tool";
  return MessageRole;
}({});
let ChatCompletionEventType = exports.ChatCompletionEventType = /*#__PURE__*/function (ChatCompletionEventType) {
  ChatCompletionEventType["ChatCompletionChunk"] = "chatCompletionChunk";
  ChatCompletionEventType["ChatCompletionTokenCount"] = "chatCompletionTokenCount";
  ChatCompletionEventType["ChatCompletionMessage"] = "chatCompletionMessage";
  return ChatCompletionEventType;
}({});
/**
 * Request a completion from the LLM based on a prompt or conversation.
 *
 * @param {string} options.connectorId The ID of the connector to use
 * @param {string} [options.system] A system message that defines the behavior of the LLM.
 * @param {Message[]} options.message A list of messages that make up the conversation to be completed.
 * @param {ToolChoice} [options.toolChoice] Force the LLM to call a (specific) tool, or no tool
 * @param {Record<string, ToolDefinition>} [options.tools] A map of tools that can be called by the LLM
 */