"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChatCompletionErrorCode = void 0;
exports.createTokenLimitReachedError = createTokenLimitReachedError;
exports.createToolNotFoundError = createToolNotFoundError;
exports.createToolValidationError = createToolValidationError;
exports.isTokenLimitReachedError = isTokenLimitReachedError;
exports.isToolNotFoundError = isToolNotFoundError;
exports.isToolValidationError = isToolValidationError;
var _i18n = require("@kbn/i18n");
var _errors = require("../errors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let ChatCompletionErrorCode = exports.ChatCompletionErrorCode = /*#__PURE__*/function (ChatCompletionErrorCode) {
  ChatCompletionErrorCode["TokenLimitReachedError"] = "tokenLimitReachedError";
  ChatCompletionErrorCode["ToolNotFoundError"] = "toolNotFoundError";
  ChatCompletionErrorCode["ToolValidationError"] = "toolValidationError";
  return ChatCompletionErrorCode;
}({});
function createTokenLimitReachedError(tokenLimit, tokenCount) {
  return new _errors.InferenceTaskError(ChatCompletionErrorCode.TokenLimitReachedError, _i18n.i18n.translate('xpack.inference.chatCompletionError.tokenLimitReachedError', {
    defaultMessage: `Token limit reached. Token limit is {tokenLimit}, but the current conversation has {tokenCount} tokens.`,
    values: {
      tokenLimit,
      tokenCount
    }
  }), {
    tokenLimit,
    tokenCount
  });
}
function createToolNotFoundError(name) {
  return new _errors.InferenceTaskError(ChatCompletionErrorCode.ToolNotFoundError, `Tool ${name} called but was not available`, {
    name
  });
}
function createToolValidationError(message, meta) {
  return new _errors.InferenceTaskError(ChatCompletionErrorCode.ToolValidationError, message, meta);
}
function isToolValidationError(error) {
  return error instanceof _errors.InferenceTaskError && error.code === ChatCompletionErrorCode.ToolValidationError;
}
function isTokenLimitReachedError(error) {
  return error instanceof _errors.InferenceTaskError && error.code === ChatCompletionErrorCode.TokenLimitReachedError;
}
function isToolNotFoundError(error) {
  return error instanceof _errors.InferenceTaskError && error.code === ChatCompletionErrorCode.ToolNotFoundError;
}