"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerGetAllRoute = registerGetAllRoute;
var _ = require("..");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function registerGetAllRoute({
  router,
  lib: {
    handleEsError
  }
}) {
  // Get all inference models
  router.get({
    path: (0, _.addBasePath)('/inference/all'),
    validate: {}
  }, async (context, request, response) => {
    const {
      client
    } = (await context.core).elasticsearch;

    // TODO: Use the client's built-in function rather than the transport when it's available
    try {
      const {
        endpoints
      } = await client.asCurrentUser.transport.request({
        method: 'GET',
        path: `/_inference/_all`
      });
      return response.ok({
        body: endpoints
      });
    } catch (error) {
      return handleEsError({
        error,
        response
      });
    }
  });
}