"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndexMgmtUIPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _semver = _interopRequireDefault(require("semver/classes/semver"));
var _extension_service = require("./application/store/selectors/extension_service");
var _extensions_service = require("./services/extensions_service");
var _plugin = require("../common/constants/plugin");
var _index_mappings_embeddable = require("./application/sections/home/index_list/details_page/with_context_components/index_mappings_embeddable");
var _public_api_service = require("./services/public_api_service");
var _index_settings_embeddable = require("./application/sections/home/index_list/details_page/with_context_components/index_settings_embeddable");
var _locator = require("./locator");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */ // avoid import from index files in plugin.ts, use specific import paths
class IndexMgmtUIPlugin {
  constructor(ctx) {
    (0, _defineProperty2.default)(this, "extensionsService", new _extensions_service.ExtensionsService());
    (0, _defineProperty2.default)(this, "locator", void 0);
    (0, _defineProperty2.default)(this, "kibanaVersion", void 0);
    (0, _defineProperty2.default)(this, "config", void 0);
    // Temporary hack to provide the service instances in module files in order to avoid a big refactor
    // For the selectors we should expose them through app dependencies and read them from there on each container component.
    (0, _extension_service.setExtensionsService)(this.extensionsService);
    this.kibanaVersion = new _semver.default(ctx.env.packageInfo.version);
    const {
      ui: {
        enabled: isIndexManagementUiEnabled
      },
      enableIndexActions,
      enableLegacyTemplates,
      enableIndexStats,
      enableSizeAndDocCount,
      enableDataStreamStats,
      editableIndexSettings,
      enableMappingsSourceFieldSection,
      enableTogglingDataRetention,
      dev: {
        enableSemanticText
      }
    } = ctx.config.get();
    this.config = {
      isIndexManagementUiEnabled,
      enableIndexActions: enableIndexActions !== null && enableIndexActions !== void 0 ? enableIndexActions : true,
      enableLegacyTemplates: enableLegacyTemplates !== null && enableLegacyTemplates !== void 0 ? enableLegacyTemplates : true,
      enableIndexStats: enableIndexStats !== null && enableIndexStats !== void 0 ? enableIndexStats : true,
      enableSizeAndDocCount: enableSizeAndDocCount !== null && enableSizeAndDocCount !== void 0 ? enableSizeAndDocCount : true,
      enableDataStreamStats: enableDataStreamStats !== null && enableDataStreamStats !== void 0 ? enableDataStreamStats : true,
      editableIndexSettings: editableIndexSettings !== null && editableIndexSettings !== void 0 ? editableIndexSettings : 'all',
      enableMappingsSourceFieldSection: enableMappingsSourceFieldSection !== null && enableMappingsSourceFieldSection !== void 0 ? enableMappingsSourceFieldSection : true,
      enableTogglingDataRetention: enableTogglingDataRetention !== null && enableTogglingDataRetention !== void 0 ? enableTogglingDataRetention : true,
      enableSemanticText: enableSemanticText !== null && enableSemanticText !== void 0 ? enableSemanticText : true
    };
  }
  setup(coreSetup, plugins) {
    if (this.config.isIndexManagementUiEnabled) {
      const {
        fleet,
        usageCollection,
        management,
        cloud
      } = plugins;
      management.sections.section.data.registerApp({
        id: _plugin.PLUGIN.id,
        title: _i18n.i18n.translate('xpack.idxMgmt.appTitle', {
          defaultMessage: 'Index Management'
        }),
        order: 0,
        mount: async params => {
          const {
            mountManagementSection
          } = await Promise.resolve().then(() => _interopRequireWildcard(require('./application/mount_management_section')));
          return mountManagementSection({
            coreSetup,
            usageCollection,
            params,
            extensionsService: this.extensionsService,
            isFleetEnabled: Boolean(fleet),
            kibanaVersion: this.kibanaVersion,
            config: this.config,
            cloud
          });
        }
      });
    }
    this.locator = plugins.share.url.locators.create(new _locator.IndexManagementLocatorDefinition({
      managementAppLocator: plugins.management.locator
    }));
    return {
      apiService: new _public_api_service.PublicApiService(coreSetup.http),
      extensionsService: this.extensionsService.setup(),
      locator: this.locator
    };
  }
  start(coreStart, plugins) {
    const {
      fleet,
      usageCollection,
      cloud,
      share,
      console,
      ml,
      licensing
    } = plugins;
    return {
      extensionsService: this.extensionsService.setup(),
      getIndexMappingComponent: deps => {
        const {
          docLinks,
          fatalErrors,
          application,
          uiSettings,
          executionContext,
          settings,
          http
        } = coreStart;
        const {
          url
        } = share;
        const appDependencies = {
          core: {
            fatalErrors,
            getUrlForApp: application.getUrlForApp,
            executionContext,
            application,
            http
          },
          plugins: {
            usageCollection,
            isFleetEnabled: Boolean(fleet),
            share,
            cloud,
            console,
            ml,
            licensing
          },
          services: {
            extensionsService: this.extensionsService
          },
          config: this.config,
          history: deps.history,
          setBreadcrumbs: undefined,
          // breadcrumbService.setBreadcrumbs,
          uiSettings,
          settings,
          url,
          docLinks,
          kibanaVersion: this.kibanaVersion,
          theme$: coreStart.theme.theme$
        };
        return props => {
          return (0, _index_mappings_embeddable.IndexMapping)({
            dependencies: appDependencies,
            core: coreStart,
            ...props
          });
        };
      },
      getIndexSettingsComponent: deps => {
        const {
          docLinks,
          fatalErrors,
          application,
          uiSettings,
          executionContext,
          settings,
          http
        } = coreStart;
        const {
          url
        } = share;
        const appDependencies = {
          core: {
            fatalErrors,
            getUrlForApp: application.getUrlForApp,
            executionContext,
            application,
            http
          },
          plugins: {
            usageCollection,
            isFleetEnabled: Boolean(fleet),
            share,
            cloud,
            console,
            ml,
            licensing
          },
          services: {
            extensionsService: this.extensionsService
          },
          config: this.config,
          history: deps.history,
          setBreadcrumbs: undefined,
          // breadcrumbService.setBreadcrumbs,
          uiSettings,
          settings,
          url,
          docLinks,
          kibanaVersion: this.kibanaVersion,
          theme$: coreStart.theme.theme$
        };
        return props => {
          return (0, _index_settings_embeddable.IndexSettings)({
            dependencies: appDependencies,
            core: coreStart,
            ...props
          });
        };
      }
    };
  }
  stop() {}
}
exports.IndexMgmtUIPlugin = IndexMgmtUIPlugin;