"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndexTable = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _queryString = _interopRequireDefault(require("query-string"));
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _shared_imports = require("../../../../../shared_imports");
var _routing = require("../../../../services/routing");
var _documentation = require("../../../../services/documentation");
var _app_context = require("../../../../app_context");
var _render_badges = require("../../../../lib/render_badges");
var _components = require("../../../../components");
var _index_actions_context_menu = require("../index_actions_context_menu");
var _create_index_button = require("../create_index/create_index_button");
var _index_table_pagination = require("./index_table_pagination");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getColumnConfigs = ({
  showIndexStats,
  history,
  filterChanged,
  extensionsService,
  location,
  application,
  http
}) => {
  const columns = [{
    fieldName: 'name',
    label: _i18n.i18n.translate('xpack.idxMgmt.indexTable.headers.nameHeader', {
      defaultMessage: 'Name'
    }),
    order: 10,
    render: index => {
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "indexTableIndexNameLink",
        onClick: () => {
          if (!extensionsService.indexDetailsPageRoute) {
            history.push((0, _routing.getIndexDetailsLink)(index.name, location.search || ''));
          } else {
            const route = extensionsService.indexDetailsPageRoute.renderRoute(index.name);
            application.navigateToUrl(http.basePath.prepend(route));
          }
        }
      }, index.name), (0, _render_badges.renderBadges)(index, extensionsService, filterChanged));
    }
  }, {
    fieldName: 'data_stream',
    label: _i18n.i18n.translate('xpack.idxMgmt.indexTable.headers.dataStreamHeader', {
      defaultMessage: 'Data stream'
    }),
    order: 80,
    render: index => {
      if (index.data_stream) {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, (0, _extends2.default)({
          "data-test-subj": "dataStreamLink"
        }, (0, _shared_imports.reactRouterNavigate)(history, {
          pathname: (0, _routing.getDataStreamDetailsLink)(index.data_stream),
          search: '?isDeepLink=true'
        })), index.data_stream);
      }
    }
  }];
  if (showIndexStats) {
    columns.push({
      fieldName: 'health',
      label: _i18n.i18n.translate('xpack.idxMgmt.indexTable.headers.healthHeader', {
        defaultMessage: 'Health'
      }),
      order: 20,
      render: index => /*#__PURE__*/_react.default.createElement(_components.DataHealth, {
        health: index.health
      })
    }, {
      fieldName: 'status',
      label: _i18n.i18n.translate('xpack.idxMgmt.indexTable.headers.statusHeader', {
        defaultMessage: 'Status'
      }),
      order: 30
    }, {
      fieldName: 'primary',
      label: _i18n.i18n.translate('xpack.idxMgmt.indexTable.headers.primaryHeader', {
        defaultMessage: 'Primaries'
      }),
      order: 40
    }, {
      fieldName: 'replica',
      label: _i18n.i18n.translate('xpack.idxMgmt.indexTable.headers.replicaHeader', {
        defaultMessage: 'Replicas'
      }),
      order: 50
    }, {
      fieldName: 'documents',
      label: _i18n.i18n.translate('xpack.idxMgmt.indexTable.headers.documentsHeader', {
        defaultMessage: 'Docs count'
      }),
      order: 60,
      render: index => {
        if (index.documents) {
          return Number(index.documents).toLocaleString();
        }
      }
    }, {
      fieldName: 'size',
      label: _i18n.i18n.translate('xpack.idxMgmt.indexTable.headers.storageSizeHeader', {
        defaultMessage: 'Storage size'
      }),
      order: 70
    });
  }
  columns.push(...extensionsService.columns);
  return columns.sort(({
    order: orderA
  }, {
    order: orderB
  }) => orderA - orderB);
};
class IndexTable extends _react.Component {
  static getDerivedStateFromProps(props, state) {
    // Deselect any indices which no longer exist, e.g. they've been deleted.
    const {
      selectedIndicesMap
    } = state;
    const indexNames = props.indices.map(index => index.name);
    const selectedIndexNames = Object.keys(selectedIndicesMap);
    const missingIndexNames = selectedIndexNames.filter(selectedIndexName => {
      return !indexNames.includes(selectedIndexName);
    });
    if (missingIndexNames.length) {
      const newMap = {
        ...selectedIndicesMap
      };
      missingIndexNames.forEach(missingIndexName => delete newMap[missingIndexName]);
      return {
        selectedIndicesMap: newMap
      };
    }
    return null;
  }
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "onSort", column => {
      const {
        sortField,
        isSortAscending,
        sortChanged
      } = this.props;
      const newIsSortAscending = sortField === column ? !isSortAscending : true;
      sortChanged(column, newIsSortAscending);
    });
    (0, _defineProperty2.default)(this, "onFilterChanged", ({
      query,
      error
    }) => {
      if (error) {
        this.setState({
          filterError: error
        });
      } else {
        this.setURLParam('filter', encodeURIComponent(query.text));
        this.props.filterChanged(query);
        this.setState({
          filterError: null
        });
      }
    });
    (0, _defineProperty2.default)(this, "getFilters", extensionsService => {
      const {
        allIndices
      } = this.props;
      return extensionsService.filters.reduce((accum, filterExtension) => {
        const filtersToAdd = filterExtension(allIndices);
        return [...accum, ...filtersToAdd];
      }, []);
    });
    (0, _defineProperty2.default)(this, "toggleAll", () => {
      const allSelected = this.areAllItemsSelected();
      if (allSelected) {
        return this.setState({
          selectedIndicesMap: {}
        });
      }
      const {
        indices
      } = this.props;
      const selectedIndicesMap = {};
      indices.forEach(({
        name
      }) => {
        selectedIndicesMap[name] = true;
      });
      this.setState({
        selectedIndicesMap
      });
    });
    (0, _defineProperty2.default)(this, "toggleItem", name => {
      this.setState(({
        selectedIndicesMap
      }) => {
        const newMap = {
          ...selectedIndicesMap
        };
        if (newMap[name]) {
          delete newMap[name];
        } else {
          newMap[name] = true;
        }
        return {
          selectedIndicesMap: newMap
        };
      });
    });
    (0, _defineProperty2.default)(this, "isItemSelected", name => {
      return !!this.state.selectedIndicesMap[name];
    });
    (0, _defineProperty2.default)(this, "areAllItemsSelected", () => {
      const {
        indices
      } = this.props;
      if (indices.length <= 0) {
        return false;
      }
      const indexOfUnselectedItem = indices.findIndex(index => !this.isItemSelected(index.name));
      return indexOfUnselectedItem === -1;
    });
    (0, _defineProperty2.default)(this, "onItemSelectionChanged", selectedIndices => {
      this.setState({
        selectedIndices
      });
    });
    this.state = {
      selectedIndicesMap: {}
    };
  }
  componentDidMount() {
    this.props.loadIndices();
    const {
      filterChanged,
      pageSizeChanged,
      pageChanged,
      toggleNameToVisibleMap,
      toggleChanged
    } = this.props;
    const {
      filter,
      pageSize,
      pageIndex,
      ...rest
    } = this.readURLParams();
    if (filter) {
      try {
        const parsedFilter = _eui.EuiSearchBar.Query.parse(filter);
        filterChanged(parsedFilter);
      } catch (e) {
        this.setState({
          filterError: e
        });
      }
    }
    if (pageSize && _index_table_pagination.PAGE_SIZE_OPTIONS.includes(pageSize)) {
      pageSizeChanged(pageSize);
    }
    if (pageIndex && pageIndex > -1) {
      pageChanged(pageIndex);
    }
    const toggleParams = Object.keys(rest);
    const toggles = Object.keys(toggleNameToVisibleMap);
    for (const toggleParam of toggleParams) {
      if (toggles.includes(toggleParam)) {
        toggleChanged(toggleParam, rest[toggleParam] === 'true');
      }
    }
  }
  componentWillUnmount() {
    // When you deep-link to an index from the data streams tab, the hidden indices are toggled on.
    // However, this state is lost when you navigate away. We need to clear the filter too, or else
    // navigating back to this tab would just show an empty list because the backing indices
    // would be hidden.
    this.props.filterChanged('');
  }
  readURLParams() {
    const {
      location
    } = this.props;
    const {
      filter,
      pageSize,
      pageIndex,
      ...rest
    } = _queryString.default.parse(location && location.search || '');
    return {
      filter: filter ? (0, _shared_imports.attemptToURIDecode)(String(filter)) : undefined,
      pageSize: pageSize ? Number(String(pageSize)) : undefined,
      pageIndex: pageIndex ? Number(String(pageIndex)) : undefined,
      ...rest
    };
  }
  setURLParam(paramName, value) {
    const {
      location,
      history
    } = this.props;
    const {
      pathname,
      search
    } = location;
    const params = _queryString.default.parse(search);
    if (value) {
      params[paramName] = value;
    } else {
      delete params[paramName];
    }
    history.push(pathname + '?' + _queryString.default.stringify(params));
  }
  renderFilterError() {
    const {
      filterError
    } = this.state;
    if (!filterError) {
      return;
    }
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      iconType: "faceSad",
      color: "danger",
      title: _i18n.i18n.translate('xpack.idxMgmt.indexTable.invalidSearchErrorMessage', {
        defaultMessage: 'Invalid search: {errorMessage}',
        values: {
          errorMessage: filterError.message
        }
      })
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null));
  }
  buildHeader(columnConfigs) {
    const {
      sortField,
      isSortAscending
    } = this.props;
    return columnConfigs.map(({
      fieldName,
      label
    }) => {
      const isSorted = sortField === fieldName;
      // we only want to make index name column 25% width when there are more columns displayed
      const widthClassName = fieldName === 'name' && columnConfigs.length > 2 ? 'indTable__header__width' : '';
      return /*#__PURE__*/_react.default.createElement(_eui.EuiTableHeaderCell, {
        key: fieldName,
        onSort: () => this.onSort(fieldName),
        isSorted: isSorted,
        isSortAscending: isSortAscending,
        className: widthClassName,
        "data-test-subj": `indexTableHeaderCell-${fieldName}`
      }, label);
    });
  }
  buildRowCell(index, columnConfig) {
    if (columnConfig.render) {
      return columnConfig.render(index);
    }
    return (0, _lodash.get)(index, columnConfig.fieldName);
  }
  buildRowCells(index, columnConfigs) {
    return columnConfigs.map(columnConfig => {
      const {
        name
      } = index;
      const {
        fieldName
      } = columnConfig;
      return /*#__PURE__*/_react.default.createElement(_eui.EuiTableRowCell, {
        key: `${fieldName}-${name}`,
        truncateText: false,
        setScopeRow: fieldName === 'name',
        "data-test-subj": `indexTableCell-${fieldName}`,
        className: 'indTable__cell--' + fieldName,
        header: fieldName
      }, this.buildRowCell(index, columnConfig));
    });
  }
  renderBanners(extensionsService) {
    const {
      allIndices = [],
      filterChanged
    } = this.props;
    return extensionsService.banners.map((bannerExtension, i) => {
      const bannerData = bannerExtension(allIndices);
      if (!bannerData) {
        return null;
      }
      const {
        type,
        title,
        message,
        filter,
        filterLabel
      } = bannerData;
      return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
        key: `bannerExtension${i}`
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
        color: type,
        size: "m",
        title: title
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, message, filter ? /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        onClick: () => filterChanged(filter)
      }, filterLabel) : null)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "m"
      }));
    });
  }
  buildRows(columnConfigs) {
    const {
      indices = []
    } = this.props;
    return indices.map(index => {
      const {
        name
      } = index;
      return /*#__PURE__*/_react.default.createElement(_eui.EuiTableRow, {
        "data-test-subj": "indexTableRow",
        isSelected: this.isItemSelected(name),
        isSelectable: true,
        hasSelection: true,
        key: `${name}-row`
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiTableRowCellCheckbox, {
        key: `checkbox-${name}`
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
        id: `checkboxSelectIndex-${name}`,
        checked: this.isItemSelected(name),
        onChange: () => {
          this.toggleItem(name);
        },
        "data-test-subj": "indexTableRowCheckbox",
        "aria-label": _i18n.i18n.translate('xpack.idxMgmt.indexTable.selectIndexAriaLabel', {
          defaultMessage: 'Select this row'
        })
      })), this.buildRowCells(index, columnConfigs));
    });
  }
  renderToggleControl({
    name,
    label
  }) {
    const {
      toggleNameToVisibleMap,
      toggleChanged
    } = this.props;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      key: name,
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
      id: `checkboxToggles-${name}`,
      "data-test-subj": `checkboxToggles-${name}`,
      checked: toggleNameToVisibleMap[name],
      onChange: event => {
        this.setURLParam(name, event.target.checked);
        toggleChanged(name, event.target.checked);
      },
      label: label
    }));
  }
  render() {
    const {
      filter,
      filterChanged,
      indices,
      loadIndices,
      indicesLoading,
      indicesError,
      allIndices,
      pager,
      pageChanged,
      pageSizeChanged,
      history,
      location
    } = this.props;
    const hasContent = !indicesLoading && !indicesError;
    if (!hasContent) {
      if (indicesLoading) {
        return /*#__PURE__*/_react.default.createElement(_shared_imports.PageLoading, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.idxMgmt.indexTable.loadingIndicesDescription",
          defaultMessage: "Loading indices\u2026"
        }));
      }
      if (indicesError) {
        if (indicesError.status === 403) {
          return /*#__PURE__*/_react.default.createElement(_shared_imports.PageError, {
            title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
              id: "xpack.idxMgmt.pageErrorForbidden.title",
              defaultMessage: "You do not have permissions to use Index Management"
            })
          });
        }
        return /*#__PURE__*/_react.default.createElement(_shared_imports.PageError, {
          title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.idxMgmt.indexTable.serverErrorTitle",
            defaultMessage: "Error loading indices"
          }),
          error: indicesError.body
        });
      }
    }
    const {
      selectedIndicesMap
    } = this.state;
    const atLeastOneItemSelected = Object.keys(selectedIndicesMap).length > 0;
    return /*#__PURE__*/_react.default.createElement(_app_context.AppContextConsumer, null, ({
      services,
      config,
      core
    }) => {
      const {
        extensionsService
      } = services;
      const {
        application,
        http
      } = core;
      const columnConfigs = getColumnConfigs({
        showIndexStats: config.enableIndexStats,
        extensionsService,
        filterChanged,
        history,
        location,
        application,
        http
      });
      const columnsCount = columnConfigs.length + 1;
      return /*#__PURE__*/_react.default.createElement(_eui.EuiPageSection, {
        paddingSize: "none"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        alignItems: "center"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: true
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        color: "subdued"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.idxMgmt.home.idxMgmtDescription",
        defaultMessage: "Update your Elasticsearch indices individually or in bulk. {learnMoreLink}",
        values: {
          learnMoreLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
            href: _documentation.documentationService.getIdxMgmtDocumentationLink(),
            target: "_blank",
            external: true
          }, _i18n.i18n.translate('xpack.idxMgmt.indexTableDescription.learnMoreLinkText', {
            defaultMessage: 'Learn more.'
          }))
        }
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, indicesLoading && allIndices.length === 0 || indicesError ? null : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, extensionsService.toggles.map(toggle => {
        return this.renderToggleControl(toggle);
      })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "l"
      }), this.renderBanners(extensionsService), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        gutterSize: "m",
        alignItems: "center"
      }, atLeastOneItemSelected ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
        key: "menu",
        render: () => /*#__PURE__*/_react.default.createElement(_index_actions_context_menu.IndexActionsContextMenu, {
          indexNames: Object.keys(selectedIndicesMap),
          isOnListView: true,
          indicesListURLParams: location.search || '',
          resetSelection: () => {
            this.setState({
              selectedIndicesMap: {}
            });
          }
        })
      })) : null, indicesLoading && allIndices.length === 0 || indicesError ? null : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSearchBar, {
        filters: this.getFilters(extensionsService).length > 0 ? this.getFilters(extensionsService) : null,
        defaultQuery: filter,
        query: filter,
        box: {
          incremental: true,
          placeholder: _i18n.i18n.translate('xpack.idxMgmt.indexTable.systemIndicesSearchInputPlaceholder', {
            defaultMessage: 'Search'
          }),
          'data-test-subj': 'indicesSearch'
        },
        "aria-label": _i18n.i18n.translate('xpack.idxMgmt.indexTable.systemIndicesSearchIndicesAriaLabel', {
          defaultMessage: 'Search indices'
        }),
        "data-test-subj": "indexTableFilterInput",
        onChange: this.onFilterChanged
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        isLoading: indicesLoading,
        color: "success",
        onClick: loadIndices,
        iconType: "refresh",
        "data-test-subj": "reloadIndicesButton"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.idxMgmt.indexTable.reloadIndicesButton",
        defaultMessage: "Reload indices"
      })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_create_index_button.CreateIndexButton, {
        loadIndices: loadIndices
      }))), this.renderFilterError(), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "m"
      }), /*#__PURE__*/_react.default.createElement("div", {
        style: {
          maxWidth: '100%',
          overflow: 'auto'
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiTable, {
        className: "indTable",
        "data-test-subj": "indexTable"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, null, /*#__PURE__*/_react.default.createElement("caption", {
        role: "status",
        "aria-relevant": "text",
        "aria-live": "polite"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.idxMgmt.indexTable.captionText",
        defaultMessage: "Below is the indices table containing {count, plural, one {# row} other {# rows}} out of {total}.",
        values: {
          count: indices.length,
          total: pager.totalItems
        }
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiTableHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTableHeaderCellCheckbox, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
        id: "selectAllIndexes",
        checked: this.areAllItemsSelected(),
        onChange: this.toggleAll,
        "aria-label": _i18n.i18n.translate('xpack.idxMgmt.indexTable.selectAllIndicesAriaLabel', {
          defaultMessage: 'Select all rows'
        })
      })), this.buildHeader(columnConfigs)), /*#__PURE__*/_react.default.createElement(_eui.EuiTableBody, null, indices.length > 0 ? this.buildRows(columnConfigs) : /*#__PURE__*/_react.default.createElement(_eui.EuiTableRow, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTableRowCell, {
        align: "center",
        colSpan: columnsCount
      }, /*#__PURE__*/_react.default.createElement(_components.NoMatch, {
        loadIndices: loadIndices,
        filter: filter,
        resetFilter: () => filterChanged(''),
        extensionsService: extensionsService
      })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "m"
      }), indices.length > 0 ? /*#__PURE__*/_react.default.createElement(_index_table_pagination.IndexTablePagination, {
        pager: pager,
        pageChanged: pageChanged,
        pageSizeChanged: pageSizeChanged,
        readURLParams: () => this.readURLParams(),
        setURLParam: (paramName, value) => this.setURLParam(paramName, value)
      }) : null);
    });
  }
}
exports.IndexTable = IndexTable;