"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DetailsPageOverview = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _searchApiPanels = require("@kbn/search-api-panels");
var _status_details = require("./status_details");
var _app_context = require("../../../../../app_context");
var _services = require("../../../../../services");
var _languages = require("./languages");
var _data_stream_details = require("./data_stream_details");
var _storage_details = require("./storage_details");
var _aliases_details = require("./aliases_details");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DetailsPageOverview = ({
  indexDetails
}) => {
  const {
    name,
    status,
    health,
    documents,
    documents_deleted: documentsDeleted,
    primary,
    replica,
    aliases,
    data_stream: dataStream,
    size,
    primary_size: primarySize
  } = indexDetails;
  const {
    core,
    plugins,
    services: {
      extensionsService
    }
  } = (0, _app_context.useAppContext)();
  const [selectedLanguage, setSelectedLanguage] = (0, _react.useState)(_languages.curlDefinition);
  const [elasticsearchUrl, setElasticsearchUrl] = (0, _react.useState)('');
  (0, _react.useEffect)(() => {
    var _plugins$cloud;
    (_plugins$cloud = plugins.cloud) === null || _plugins$cloud === void 0 ? void 0 : _plugins$cloud.fetchElasticsearchConfig().then(config => {
      setElasticsearchUrl(config.elasticsearchUrl || 'https://your_deployment_url');
    });
  }, [plugins.cloud]);
  const codeSnippetArguments = {
    url: elasticsearchUrl,
    apiKey: 'your_api_key',
    indexName: name
  };
  const isLarge = (0, _eui.useIsWithinBreakpoints)(['xl']);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    columns: isLarge ? 3 : 1
  }, /*#__PURE__*/_react.default.createElement(_storage_details.StorageDetails, {
    size: size,
    primarySize: primarySize,
    primary: primary,
    replica: replica
  }), /*#__PURE__*/_react.default.createElement(_status_details.StatusDetails, {
    documents: documents,
    documentsDeleted: documentsDeleted,
    status: status,
    health: health
  }), /*#__PURE__*/_react.default.createElement(_aliases_details.AliasesDetails, {
    aliases: aliases
  }), dataStream && /*#__PURE__*/_react.default.createElement(_data_stream_details.DataStreamDetails, {
    dataStreamName: dataStream
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), extensionsService.indexOverviewContent ? extensionsService.indexOverviewContent.renderContent({
    index: indexDetails,
    getUrlForApp: core.getUrlForApp
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.idxMgmt.indexDetails.overviewTab.addMoreDataTitle', {
    defaultMessage: 'Add data to this index'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.indexDetails.overviewTab.addMoreDataDescription",
    defaultMessage: "Use the bulk API to add data to your index. {docsLink}",
    values: {
      docsLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: _services.documentationService.getBulkApi(),
        target: "_blank",
        external: true
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.idxMgmt.indexDetails.overviewTab.addDocsLink",
        defaultMessage: "Learn more."
      }))
    }
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_searchApiPanels.CodeBox, {
    languages: _languages.languageDefinitions,
    codeSnippet: (0, _searchApiPanels.getLanguageDefinitionCodeSnippet)(selectedLanguage, 'ingestDataIndex', codeSnippetArguments),
    selectedLanguage: selectedLanguage,
    setSelectedLanguage: setSelectedLanguage,
    assetBasePath: core.http.basePath.prepend(`/plugins/indexManagement/assets`),
    sharePlugin: plugins.share,
    application: core.application,
    consoleRequest: (0, _searchApiPanels.getConsoleRequest)('ingestDataIndex', codeSnippetArguments)
  }))));
};
exports.DetailsPageOverview = DetailsPageOverview;