"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CreateIndexModal = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _services = require("../../../../services");
var _notification = require("../../../../services/notification");
var _utils = require("./utils");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const INVALID_INDEX_NAME_ERROR = _i18n.i18n.translate('xpack.idxMgmt.createIndex.modal.invalidName.error', {
  defaultMessage: 'Index name is not valid'
});
const CreateIndexModal = ({
  closeModal,
  loadIndices
}) => {
  const [indexName, setIndexName] = (0, _react.useState)('');
  const [indexNameError, setIndexNameError] = (0, _react.useState)();
  const [isSaving, setIsSaving] = (0, _react.useState)(false);
  const [createError, setCreateError] = (0, _react.useState)();
  const putCreateIndex = (0, _react.useCallback)(async () => {
    setIsSaving(true);
    try {
      const {
        error
      } = await (0, _services.createIndex)(indexName);
      setIsSaving(false);
      if (!error) {
        _notification.notificationService.showSuccessToast(_i18n.i18n.translate('xpack.idxMgmt.createIndex.successfullyCreatedIndexMessage', {
          defaultMessage: 'Successfully created index: {indexName}',
          values: {
            indexName
          }
        }));
        closeModal();
        loadIndices();
        return;
      }
      setCreateError(error.message);
    } catch (e) {
      setIsSaving(false);
      setCreateError(e.message);
    }
  }, [closeModal, indexName, loadIndices]);
  const onSave = () => {
    if ((0, _utils.isValidIndexName)(indexName)) {
      putCreateIndex();
    }
  };
  const onNameChange = name => {
    setIndexName(name);
    if (!(0, _utils.isValidIndexName)(name)) {
      setIndexNameError(INVALID_INDEX_NAME_ERROR);
    } else if (indexNameError) {
      setIndexNameError(undefined);
    }
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    onClose: closeModal,
    initialFocus: "[name=indexName]"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.createIndex.modal.title",
    defaultMessage: "Create index"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, null, createError && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "danger",
    iconType: "error",
    title: _i18n.i18n.translate('xpack.idxMgmt.createIndex.modal.error.title', {
      defaultMessage: 'Error creating index'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.createIndex.modal.error.description",
    defaultMessage: "Error creating index: {errorMessage}",
    values: {
      errorMessage: createError
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    id: "createIndexModalForm",
    component: "form"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.idxMgmt.createIndex.modal.indexName.label', {
      defaultMessage: 'Index name'
    }),
    isDisabled: isSaving,
    isInvalid: indexNameError !== undefined,
    error: indexNameError
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    fullWidth: true,
    name: "indexName",
    value: indexName,
    onChange: e => onNameChange(e.target.value),
    "data-test-subj": "createIndexNameFieldText"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: closeModal,
    disabled: isSaving,
    "data-test-subj": "createIndexCancelButton",
    "data-telemetry-id": "idxMgmt-indexList-createIndex-cancelButton"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.createIndex.modal.cancelButton",
    defaultMessage: "Cancel"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    disabled: indexNameError !== undefined,
    isLoading: isSaving,
    type: "submit",
    onClick: onSave,
    form: "createIndexModalForm",
    "data-test-subj": "createIndexSaveButton",
    "data-telemetry-id": "idxMgmt-indexList-createIndex-saveButton"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.createIndex.modal.saveButton",
    defaultMessage: "Create"
  }))));
};
exports.CreateIndexModal = CreateIndexModal;