"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataStreamsBadges = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _data_streams = require("../../../lib/data_streams");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DataStreamsBadges = ({
  dataStream
}) => {
  const badges = [];
  if ((0, _data_streams.isManaged)(dataStream)) {
    badges.push( /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "hollow",
      key: 'managed'
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.dataStreamList.table.managedDataStreamBadge",
      defaultMessage: "Managed"
    })));
  }
  if (dataStream.hidden) {
    badges.push( /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "hollow",
      key: 'hidden'
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.dataStreamList.table.hiddenDataStreamBadge",
      defaultMessage: "Hidden"
    })));
  }
  return badges.length > 0 ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, "\xA0", /*#__PURE__*/_react.default.createElement(_eui.EuiBadgeGroup, null, badges)) : null;
};
exports.DataStreamsBadges = DataStreamsBadges;