"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchResultItem = void 0;
var _react = _interopRequireDefault(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _constants = require("../../../constants");
var _mappings_state_context = require("../../../mappings_state_context");
var _lib = require("../../../lib");
var _delete_field_provider = require("../fields/delete_field_provider");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SearchResultItem = exports.SearchResultItem = /*#__PURE__*/_react.default.memo(function FieldListItemFlatComponent({
  item: {
    display,
    field
  },
  areActionButtonsVisible,
  isHighlighted,
  isDimmed
}) {
  var _TYPE_DEFINITION$sour, _TYPE_DEFINITION$sour2;
  const dispatch = (0, _mappings_state_context.useDispatch)();
  const {
    source,
    isMultiField,
    hasChildFields,
    hasMultiFields
  } = field;
  const editField = () => {
    dispatch({
      type: 'documentField.editField',
      value: field.id
    });
  };
  const renderActionButtons = () => {
    if (!areActionButtonsVisible) {
      return null;
    }
    const editButtonLabel = _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.editFieldButtonLabel', {
      defaultMessage: 'Edit'
    });
    const deleteButtonLabel = _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.removeFieldButtonLabel', {
      defaultMessage: 'Remove'
    });
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      className: "mappingsEditor__fieldsListItem__actions",
      "data-test-subj": "fieldActions"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: editButtonLabel
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      iconType: "pencil",
      onClick: editField,
      "data-test-subj": "editFieldButton",
      "aria-label": editButtonLabel
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_delete_field_provider.DeleteFieldProvider, null, deleteField => /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: deleteButtonLabel
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      iconType: "trash",
      color: "danger",
      onClick: () => deleteField(field),
      "data-test-subj": "removeFieldButton",
      "aria-label": deleteButtonLabel
    })))));
  };
  return /*#__PURE__*/_react.default.createElement("div", {
    className: (0, _classnames.default)('mappingsEditor__fieldsListItem'),
    "data-test-subj": "fieldsListItem"
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: (0, _classnames.default)('mappingsEditor__fieldsListItem__field', {
      'mappingsEditor__fieldsListItem__field--enabled': areActionButtonsVisible,
      'mappingsEditor__fieldsListItem__field--selected': isHighlighted,
      'mappingsEditor__fieldsListItem__field--dim': isDimmed
    })
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: (0, _classnames.default)('mappingsEditor__fieldsListItem__wrapper')
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center",
    className: (0, _classnames.default)('mappingsEditor__fieldsListItem__content', {
      'mappingsEditor__fieldsListItem__content--toggle': hasChildFields || hasMultiFields,
      'mappingsEditor__fieldsListItem__content--multiField': isMultiField
    }),
    tabIndex: 0
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    className: "mappingsEditor__fieldsListItem__name",
    "data-test-subj": "fieldName"
  }, display), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    "data-test-subj": "fieldType"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "hollow"
  }, isMultiField ? _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.multiFieldBadgeLabel', {
    defaultMessage: '{dataType} multi-field',
    values: {
      dataType: (_TYPE_DEFINITION$sour = (_TYPE_DEFINITION$sour2 = _constants.TYPE_DEFINITION[source.type]) === null || _TYPE_DEFINITION$sour2 === void 0 ? void 0 : _TYPE_DEFINITION$sour2.label) !== null && _TYPE_DEFINITION$sour !== void 0 ? _TYPE_DEFINITION$sour : source.type
    }
  }) : (0, _lib.getTypeLabelFromField)(source))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, renderActionButtons())))));
});
SearchResultItem.displayName = 'SearchResultItem'; // display name required for tests to work with React.memo