"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSemanticText = useSemanticText;
var _react = require("react");
var _mlTrainedModelsUtils = require("@kbn/ml-trained-models-utils");
var _i18n = require("@kbn/i18n");
var _use_details_page_mappings_model_management = require("../../../../../../../../hooks/use_details_page_mappings_model_management");
var _mappings_state_context = require("../../../../../mappings_state_context");
var _use_ml_model_status_toasts = require("../../../../../../../../hooks/use_ml_model_status_toasts");
var _api = require("../../../../../../../services/api");
var _utils = require("../../../../../lib/utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useSemanticText(props) {
  var _form$getFormData, _ml$mlApi2;
  const {
    form,
    setErrorsInTrainedModelDeployment,
    ml
  } = props;
  const {
    fields,
    mappingViewFields
  } = (0, _mappings_state_context.useMappingsState)();
  const {
    fetchInferenceToModelIdMap
  } = (0, _use_details_page_mappings_model_management.useDetailsPageMappingsModelManagement)();
  const dispatch = (0, _mappings_state_context.useDispatch)();
  const {
    showSuccessToasts,
    showErrorToasts
  } = (0, _use_ml_model_status_toasts.useMLModelNotificationToasts)();
  const fieldTypeValue = (_form$getFormData = form.getFormData()) === null || _form$getFormData === void 0 ? void 0 : _form$getFormData.type;
  (0, _react.useEffect)(() => {
    if (fieldTypeValue === 'semantic_text') {
      var _Object$values$find;
      const allFields = {
        byId: {
          ...fields.byId,
          ...mappingViewFields.byId
        },
        rootLevelFields: [],
        aliases: {},
        maxNestedDepth: 0
      };
      const defaultName = (0, _utils.getFieldByPathName)(allFields, 'semantic_text') ? '' : 'semantic_text';
      const referenceField = ((_Object$values$find = Object.values(allFields.byId).find(field => field.source.type === 'text' && !field.isMultiField)) === null || _Object$values$find === void 0 ? void 0 : _Object$values$find.path.join('.')) || '';
      if (!form.getFormData().name) {
        form.setFieldValue('name', defaultName);
      }
      if (!form.getFormData().reference_field) {
        form.setFieldValue('reference_field', referenceField);
      }
      if (!form.getFormData().inference_id) {
        form.setFieldValue('inference_id', 'elser_model_2');
      }
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [fieldTypeValue]);
  const createInferenceEndpoint = (0, _react.useCallback)(async (trainedModelId, inferenceId, customInferenceEndpointConfig) => {
    var _customInferenceEndpo, _ml$mlApi, _ml$mlApi$inferenceMo;
    const isElser = _mlTrainedModelsUtils.ElserModels.includes(trainedModelId);
    const defaultInferenceEndpointConfig = {
      service: isElser ? 'elser' : 'elasticsearch',
      taskType: isElser ? 'sparse_embedding' : 'text_embedding'
    };
    const modelConfig = customInferenceEndpointConfig ? customInferenceEndpointConfig.modelConfig : {
      service: defaultInferenceEndpointConfig.service,
      service_settings: {
        adaptive_allocations: {
          enabled: true
        },
        num_threads: 1,
        model_id: trainedModelId
      }
    };
    const taskType = (_customInferenceEndpo = customInferenceEndpointConfig === null || customInferenceEndpointConfig === void 0 ? void 0 : customInferenceEndpointConfig.taskType) !== null && _customInferenceEndpo !== void 0 ? _customInferenceEndpo : defaultInferenceEndpointConfig.taskType;
    await (ml === null || ml === void 0 ? void 0 : (_ml$mlApi = ml.mlApi) === null || _ml$mlApi === void 0 ? void 0 : (_ml$mlApi$inferenceMo = _ml$mlApi.inferenceModels) === null || _ml$mlApi$inferenceMo === void 0 ? void 0 : _ml$mlApi$inferenceMo.createInferenceEndpoint(inferenceId, taskType, modelConfig));
  }, [ml === null || ml === void 0 ? void 0 : (_ml$mlApi2 = ml.mlApi) === null || _ml$mlApi2 === void 0 ? void 0 : _ml$mlApi2.inferenceModels]);
  const handleSemanticText = async (data, customInferenceEndpointConfig) => {
    var _inferenceEndpoints$d;
    const modelIdMap = await fetchInferenceToModelIdMap();
    const inferenceId = data.inference_id;
    const inferenceData = modelIdMap === null || modelIdMap === void 0 ? void 0 : modelIdMap[inferenceId];
    if (!inferenceData) {
      throw new Error(_i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.semanticText.inferenceError', {
        defaultMessage: 'No inference model found for inference ID {inferenceId}',
        values: {
          inferenceId
        }
      }));
    }
    const {
      trainedModelId
    } = inferenceData;
    dispatch({
      type: 'field.add',
      value: data
    });
    const inferenceEndpoints = await (0, _api.getInferenceEndpoints)();
    const hasInferenceEndpoint = (_inferenceEndpoints$d = inferenceEndpoints.data) === null || _inferenceEndpoints$d === void 0 ? void 0 : _inferenceEndpoints$d.some(inference => inference.inference_id === inferenceId);
    // if inference endpoint exists already, do not create new inference endpoint
    if (hasInferenceEndpoint) {
      return;
    }
    try {
      // Only show toast if it's an internal Elastic model that hasn't been deployed yet
      await createInferenceEndpoint(trainedModelId, data.inference_id, customInferenceEndpointConfig);
      if (trainedModelId) {
        if (inferenceData.isDeployable && !inferenceData.isDeployed) {
          showSuccessToasts(trainedModelId);
        }
        // clear error because we've succeeded here
        setErrorsInTrainedModelDeployment === null || setErrorsInTrainedModelDeployment === void 0 ? void 0 : setErrorsInTrainedModelDeployment(prevItems => ({
          ...prevItems,
          [data.inference_id]: undefined
        }));
      }
    } catch (error) {
      // trainedModelId is empty string when it's a third party model
      if (trainedModelId) {
        setErrorsInTrainedModelDeployment === null || setErrorsInTrainedModelDeployment === void 0 ? void 0 : setErrorsInTrainedModelDeployment(prevItems => ({
          ...prevItems,
          [data.inference_id]: error
        }));
      }
      showErrorToasts(error);
    }
  };
  return {
    createInferenceEndpoint,
    handleSemanticText
  };
}