"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ReferenceFieldSelects = void 0;
var _react = _interopRequireDefault(require("react"));
var _lib = require("../../../lib");
var _mappings_state_context = require("../../../mappings_state_context");
var _shared_imports = require("../../../shared_imports");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ReferenceFieldSelects = () => {
  const {
    fields,
    mappingViewFields
  } = (0, _mappings_state_context.useMappingsState)();
  const allFields = {
    byId: {
      ...mappingViewFields.byId,
      ...fields.byId
    },
    rootLevelFields: [],
    aliases: {},
    maxNestedDepth: 0
  };
  const referenceFieldOptions = Object.values(allFields.byId).filter(field => field.source.type === 'text' && !field.isMultiField).map(field => ({
    value: field.path.join('.'),
    inputDisplay: field.path.join('.'),
    'data-test-subj': `select-reference-field-${field.path.join('.')}}`
  }));
  const fieldConfigReferenceField = (0, _lib.getFieldConfig)('reference_field');
  return /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    path: "reference_field",
    config: fieldConfigReferenceField
  }, field => /*#__PURE__*/_react.default.createElement(_shared_imports.SuperSelectField, {
    field: field,
    euiFieldProps: {
      options: referenceFieldOptions
    },
    "data-test-subj": "referenceFieldSelect"
  }));
};
exports.ReferenceFieldSelects = ReferenceFieldSelects;