"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConfigurationForm = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _app_context = require("../../../../app_context");
var _shared_imports = require("../../shared_imports");
var _constants = require("../../constants");
var _mappings_state_context = require("../../mappings_state_context");
var _dynamic_mapping_section = require("./dynamic_mapping_section");
var _source_field_section = require("./source_field_section");
var _meta_field_section = require("./meta_field_section");
var _routing_section = require("./routing_section");
var _mapper_size_plugin_section = require("./mapper_size_plugin_section");
var _subobjects_section = require("./subobjects_section");
var _configuration_form_schema = require("./configuration_form_schema");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const formSerializer = (formData, sourceFieldMode) => {
  const {
    dynamicMapping,
    sourceField,
    metaField,
    _routing,
    _size,
    subobjects
  } = formData;
  const dynamic = dynamicMapping !== null && dynamicMapping !== void 0 && dynamicMapping.enabled ? true : dynamicMapping !== null && dynamicMapping !== void 0 && dynamicMapping.throwErrorsForUnmappedFields ? 'strict' : dynamicMapping === null || dynamicMapping === void 0 ? void 0 : dynamicMapping.enabled;
  const serialized = {
    dynamic,
    numeric_detection: dynamicMapping === null || dynamicMapping === void 0 ? void 0 : dynamicMapping.numeric_detection,
    date_detection: dynamicMapping === null || dynamicMapping === void 0 ? void 0 : dynamicMapping.date_detection,
    dynamic_date_formats: dynamicMapping === null || dynamicMapping === void 0 ? void 0 : dynamicMapping.dynamic_date_formats,
    _source: sourceFieldMode ? {
      mode: sourceFieldMode
    } : sourceField,
    _meta: metaField,
    _routing,
    _size,
    subobjects
  };
  return serialized;
};
const formDeserializer = formData => {
  const {
    dynamic,
    /* eslint-disable @typescript-eslint/naming-convention */
    numeric_detection,
    date_detection,
    dynamic_date_formats,
    /* eslint-enable @typescript-eslint/naming-convention */
    _source: {
      enabled,
      includes,
      excludes
    } = {},
    _meta,
    _routing,
    // For the Mapper Size plugin
    _size,
    subobjects
  } = formData;
  return {
    dynamicMapping: {
      enabled: dynamic === 'strict' ? false : dynamic,
      throwErrorsForUnmappedFields: dynamic === 'strict' ? true : undefined,
      numeric_detection,
      date_detection,
      dynamic_date_formats
    },
    sourceField: {
      enabled,
      includes,
      excludes
    },
    metaField: _meta,
    _routing,
    _size,
    subobjects
  };
};
const ConfigurationForm = exports.ConfigurationForm = /*#__PURE__*/_react.default.memo(({
  value,
  esNodesPlugins
}) => {
  var _value$_source2, _value$_source3;
  const {
    config: {
      enableMappingsSourceFieldSection
    }
  } = (0, _app_context.useAppContext)();
  const isMounted = (0, _react.useRef)(false);
  const serializerCallback = (0, _react.useCallback)(formData => {
    var _value$_source;
    return formSerializer(formData, value === null || value === void 0 ? void 0 : (_value$_source = value._source) === null || _value$_source === void 0 ? void 0 : _value$_source.mode);
  }, [value === null || value === void 0 ? void 0 : (_value$_source2 = value._source) === null || _value$_source2 === void 0 ? void 0 : _value$_source2.mode]);
  const {
    form
  } = (0, _shared_imports.useForm)({
    schema: _configuration_form_schema.configurationFormSchema,
    serializer: serializerCallback,
    deserializer: formDeserializer,
    defaultValue: value,
    id: 'configurationForm',
    options: {
      stripUnsetFields: true
    }
  });
  const dispatch = (0, _mappings_state_context.useDispatch)();
  const {
    subscribe,
    submit,
    reset,
    getFormData
  } = form;
  const isMapperSizeSectionVisible = (value === null || value === void 0 ? void 0 : value._size) !== undefined || esNodesPlugins.includes(_constants.MapperSizePluginId);
  (0, _react.useEffect)(() => {
    const subscription = subscribe(({
      data,
      isValid,
      validate
    }) => {
      dispatch({
        type: 'configuration.update',
        value: {
          data,
          isValid,
          validate,
          submitForm: submit
        }
      });
    });
    return subscription.unsubscribe;
  }, [dispatch, subscribe, submit]);
  (0, _react.useEffect)(() => {
    if (isMounted.current) {
      // If the value has changed (it probably means that we have loaded a new JSON)
      // we need to reset the form to update the fields values.
      reset({
        resetValues: true,
        defaultValue: value
      });
    }
  }, [value, reset]);
  (0, _react.useEffect)(() => {
    isMounted.current = true;
    return () => {
      isMounted.current = false;

      // Save a snapshot of the form state so we can get back to it when navigating back to the tab
      const configurationData = getFormData();
      dispatch({
        type: 'configuration.save',
        value: configurationData
      });
    };
  }, [getFormData, dispatch]);
  return /*#__PURE__*/_react.default.createElement(_shared_imports.Form, {
    form: form,
    isInvalid: form.isSubmitted && !form.isValid,
    error: form.getErrors(),
    "data-test-subj": "advancedConfiguration"
  }, /*#__PURE__*/_react.default.createElement(_dynamic_mapping_section.DynamicMappingSection, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl"
  }), /*#__PURE__*/_react.default.createElement(_meta_field_section.MetaFieldSection, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl"
  }), enableMappingsSourceFieldSection && !(value !== null && value !== void 0 && (_value$_source3 = value._source) !== null && _value$_source3 !== void 0 && _value$_source3.mode) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_source_field_section.SourceFieldSection, null), " ", /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl"
  })), /*#__PURE__*/_react.default.createElement(_routing_section.RoutingSection, null), isMapperSizeSectionVisible && /*#__PURE__*/_react.default.createElement(_mapper_size_plugin_section.MapperSizePluginSection, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl"
  }), /*#__PURE__*/_react.default.createElement(_subobjects_section.SubobjectsSection, null));
});