"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StepLogistics = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _shared_imports = require("../../../shared_imports");
var _shared = require("../../../../shared");
var _component_templates_context = require("../../../component_templates_context");
var _step_logistics_schema = require("./step_logistics_schema");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const UseField = (0, _shared_imports.getUseField)({
  component: _shared_imports.Field
});
const FormRow = (0, _shared_imports.getFormRow)({
  titleTag: 'h3'
});
const StepLogistics = exports.StepLogistics = /*#__PURE__*/_react.default.memo(({
  defaultValue,
  isEditing,
  onChange
}) => {
  const {
    form
  } = (0, _shared_imports.useForm)({
    schema: _step_logistics_schema.logisticsFormSchema,
    defaultValue,
    options: {
      stripEmptyFields: false
    }
  });
  const {
    isValid: isFormValid,
    submit,
    getFormData,
    subscribe
  } = form;
  const [{
    lifecycle
  }] = (0, _shared_imports.useFormData)({
    form,
    watch: ['lifecycle.enabled', 'lifecycle.infiniteDataRetention']
  });
  const {
    documentation
  } = (0, _component_templates_context.useComponentTemplatesContext)();
  const [isMetaVisible, setIsMetaVisible] = (0, _react.useState)(Boolean(defaultValue._meta && Object.keys(defaultValue._meta).length));
  const validate = (0, _react.useCallback)(async () => {
    return (await submit()).isValid;
  }, [submit]);
  (0, _react.useEffect)(() => {
    onChange({
      isValid: isFormValid,
      validate,
      getData: getFormData
    });
  }, [isFormValid, getFormData, validate, onChange]);
  (0, _react.useEffect)(() => {
    const subscription = subscribe(({
      data,
      isValid
    }) => {
      onChange({
        isValid,
        validate,
        getData: data.format
      });
    });
    return subscription.unsubscribe;
  }, [subscribe, validate, onChange]);
  return /*#__PURE__*/_react.default.createElement(_shared_imports.Form, {
    form: form,
    "data-test-subj": "stepLogistics"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.componentTemplateForm.stepLogistics.stepTitle",
    defaultMessage: "Logistics"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "s",
    flush: "right",
    href: documentation.componentTemplates,
    target: "_blank",
    iconType: "help",
    "data-test-subj": "documentationLink"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.componentTemplateForm.stepLogistics.docsButtonLabel",
    defaultMessage: "Component Templates docs"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(FormRow, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.componentTemplateForm.stepLogistics.nameTitle",
      defaultMessage: "Name"
    }),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.componentTemplateForm.stepLogistics.nameDescription",
      defaultMessage: "Unique name for this component template."
    })
  }, /*#__PURE__*/_react.default.createElement(UseField, {
    path: "name",
    componentProps: {
      ['data-test-subj']: 'nameField',
      euiFieldProps: {
        disabled: isEditing
      }
    }
  })), /*#__PURE__*/_react.default.createElement(FormRow, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.componentTemplateForm.stepLogistics.dataRetentionTitle",
      defaultMessage: "Data retention"
    }),
    description: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.componentTemplateForm.stepLogistics.dataRetentionDescription",
      defaultMessage: "Data will be kept at least this long before being automatically deleted."
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), /*#__PURE__*/_react.default.createElement(UseField, {
      path: "lifecycle.enabled",
      componentProps: {
        'data-test-subj': 'dataRetentionToggle'
      }
    }))
  }, (lifecycle === null || lifecycle === void 0 ? void 0 : lifecycle.enabled) && /*#__PURE__*/_react.default.createElement(UseField, {
    path: "lifecycle.value",
    component: _shared_imports.NumericField,
    labelAppend: /*#__PURE__*/_react.default.createElement(UseField, {
      path: "lifecycle.infiniteDataRetention",
      "data-test-subj": "infiniteDataRetentionToggle",
      componentProps: {
        euiFieldProps: {
          compressed: true
        }
      }
    }),
    componentProps: {
      euiFieldProps: {
        disabled: lifecycle === null || lifecycle === void 0 ? void 0 : lifecycle.infiniteDataRetention,
        'data-test-subj': 'valueDataRetentionField',
        min: 1,
        append: /*#__PURE__*/_react.default.createElement(_shared.UnitField, {
          path: "lifecycle.unit",
          options: _shared.timeUnits,
          disabled: lifecycle === null || lifecycle === void 0 ? void 0 : lifecycle.infiniteDataRetention,
          euiFieldProps: {
            'data-test-subj': 'unitDataRetentionField'
          }
        })
      }
    }
  })), /*#__PURE__*/_react.default.createElement(FormRow, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.componentTemplateForm.stepLogistics.versionTitle",
      defaultMessage: "Version"
    }),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.componentTemplateForm.stepLogistics.versionDescription",
      defaultMessage: "Number used by external management systems to identify the component template."
    })
  }, /*#__PURE__*/_react.default.createElement(UseField, {
    path: "version",
    componentProps: {
      ['data-test-subj']: 'versionField'
    }
  })), /*#__PURE__*/_react.default.createElement(FormRow, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.componentTemplateForm.stepLogistics.metaTitle",
      defaultMessage: "Metadata"
    }),
    description: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.componentTemplateForm.stepLogistics.metaDescription",
      defaultMessage: "Arbitrary information about the template, stored in the cluster state. {learnMoreLink}",
      values: {
        learnMoreLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: documentation.componentTemplatesMetadata,
          target: "_blank",
          external: true
        }, _i18n.i18n.translate('xpack.idxMgmt.componentTemplateForm.stepLogistics.metaDocumentionLink', {
          defaultMessage: 'Learn more.'
        }))
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.idxMgmt.componentTemplateForm.stepLogistics.metadataDescription",
        defaultMessage: "Add metadata"
      }),
      checked: isMetaVisible,
      onChange: e => setIsMetaVisible(e.target.checked),
      "data-test-subj": "metaToggle"
    }))
  }, isMetaVisible && /*#__PURE__*/_react.default.createElement(UseField, {
    path: "_meta",
    component: _shared_imports.JsonEditorField,
    componentProps: {
      codeEditorProps: {
        ['data-test-subj']: 'metaEditor',
        height: '200px',
        'aria-label': _i18n.i18n.translate('xpack.idxMgmt.componentTemplateForm.stepLogistics.metaAriaLabel', {
          defaultMessage: '_meta field data editor'
        })
      }
    }
  })));
});