"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InstructionSet = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _instruction = require("./instruction");
var _parameter_form = require("./parameter_form");
var _content = require("./content");
var _instruction_variant = require("../../../../common/instruction_variant");
var _eui = require("@elastic/eui");
var StatusCheckStates = _interopRequireWildcard(require("./status_check_states"));
var _i18nReact = require("@kbn/i18n-react");
var _uiTheme = require("@kbn/ui-theme");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

class InstructionSetUi extends _react.default.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "handleToggleVisibility", () => {
      this.setState(prevState => ({
        isParamFormVisible: !prevState.isParamFormVisible
      }));
    });
    (0, _defineProperty2.default)(this, "onSelectedTabChanged", id => {
      this.setState({
        selectedTabId: id
      });
    });
    (0, _defineProperty2.default)(this, "renderTabs", () => {
      return this.tabs.map((tab, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
        onClick: () => this.onSelectedTabChanged(tab.id),
        isSelected: tab.id === this.state.selectedTabId,
        key: index
      }, tab.name));
    });
    (0, _defineProperty2.default)(this, "renderInstructions", () => {
      const instructionVariant = this.props.instructionVariants.find(variant => {
        return variant.id === this.state.selectedTabId;
      });
      if (!instructionVariant) {
        return;
      }
      const steps = instructionVariant.instructions.map((instruction, index) => {
        const step = /*#__PURE__*/_react.default.createElement(_instruction.Instruction, {
          commands: instruction.commands,
          paramValues: this.props.paramValues,
          textPre: instruction.textPre,
          textPost: instruction.textPost,
          replaceTemplateStrings: this.props.replaceTemplateStrings,
          customComponentName: instruction.customComponentName,
          variantId: instructionVariant.id,
          isCloudEnabled: this.props.isCloudEnabled
        });
        return {
          title: instruction.title,
          children: step,
          key: index
        };
      });
      if (this.props.statusCheckConfig) {
        steps.push(this.renderStatusCheck());
      }
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSteps, {
        titleSize: "xs",
        steps: steps,
        firstStepNumber: this.props.offset
      }));
    });
    (0, _defineProperty2.default)(this, "renderHeader", () => {
      let paramsVisibilityToggle;
      if (this.props.params) {
        paramsVisibilityToggle = /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
          size: "s",
          iconType: this.state.isParamFormVisible ? 'arrowDown' : 'arrowRight',
          "aria-pressed": this.state.isParamFormVisible,
          onClick: this.handleToggleVisibility
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "home.tutorial.instructionSet.customizeLabel",
          defaultMessage: "Customize your code snippets"
        }));
      }
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        responsive: false,
        wrap: true,
        justifyContent: "spaceBetween"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
        size: "m"
      }, /*#__PURE__*/_react.default.createElement("h2", null, this.props.title))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, paramsVisibilityToggle));
    });
    (0, _defineProperty2.default)(this, "renderCallOut", () => {
      if (!this.props.callOut) {
        return null;
      }
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
        title: this.props.callOut.title,
        children: this.props.callOut.message,
        iconType: this.props.callOut.iconType
      }));
    });
    this.tabs = props.instructionVariants.map(variant => {
      return {
        id: variant.id,
        name: (0, _instruction_variant.getDisplayText)(variant.id),
        initialSelected: variant.initialSelected
      };
    });
    this.state = {
      isParamFormVisible: false
    };
    if (this.tabs.length > 0) {
      var _this$tabs$find$id, _this$tabs$find;
      this.state.selectedTabId = (_this$tabs$find$id = (_this$tabs$find = this.tabs.find(({
        initialSelected
      }) => initialSelected)) === null || _this$tabs$find === void 0 ? void 0 : _this$tabs$find.id) !== null && _this$tabs$find$id !== void 0 ? _this$tabs$find$id : this.tabs[0].id;
    }
  }
  renderStatusCheckMessage() {
    let message;
    let color;
    switch (this.props.statusCheckState) {
      case StatusCheckStates.NOT_CHECKED:
      case StatusCheckStates.FETCHING:
        return null;
      // Don't show any message while fetching or if you haven't yet checked.
      case StatusCheckStates.HAS_DATA:
        message = this.props.statusCheckConfig.success ? this.props.statusCheckConfig.success : this.props.intl.formatMessage({
          id: 'home.tutorial.instructionSet.successLabel',
          defaultMessage: 'Success'
        });
        color = 'success';
        break;
      case StatusCheckStates.ERROR:
      case StatusCheckStates.NO_DATA:
        message = this.props.statusCheckConfig.error ? this.props.statusCheckConfig.error : this.props.intl.formatMessage({
          id: 'home.tutorial.instructionSet.noDataLabel',
          defaultMessage: 'No data found'
        });
        color = 'warning';
        break;
    }
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      title: message,
      color: color
    }));
  }
  getStepStatus(statusCheckState) {
    switch (statusCheckState) {
      case undefined:
      case StatusCheckStates.NOT_CHECKED:
      case StatusCheckStates.FETCHING:
        return 'incomplete';
      case StatusCheckStates.HAS_DATA:
        return 'complete';
      case StatusCheckStates.NO_DATA:
        return 'warning';
      case StatusCheckStates.ERROR:
        return 'danger';
      default:
        throw new Error(this.props.intl.formatMessage({
          id: 'home.tutorial.unexpectedStatusCheckStateErrorDescription',
          defaultMessage: 'Unexpected status check state {statusCheckState}'
        }, {
          statusCheckState
        }));
    }
  }
  renderStatusCheck() {
    const {
      statusCheckState,
      statusCheckConfig,
      onStatusCheck
    } = this.props;
    const checkStatusStep = /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_content.Content, {
      text: statusCheckConfig.text
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      onClick: onStatusCheck,
      isLoading: statusCheckState === StatusCheckStates.FETCHING
    }, statusCheckConfig.btnLabel || /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "home.tutorial.instructionSet.checkStatusButtonLabel",
      defaultMessage: "Check status"
    })), this.renderStatusCheckMessage());
    return {
      title: statusCheckConfig.title || this.props.intl.formatMessage({
        id: 'home.tutorial.instructionSet.statusCheckTitle',
        defaultMessage: 'Status Check'
      }),
      status: this.getStepStatus(statusCheckState),
      children: checkStatusStep,
      key: 'checkStatusStep'
    };
  }
  render() {
    let paramsForm;
    if (this.props.params && this.state.isParamFormVisible) {
      paramsForm = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_parameter_form.ParameterForm, {
        params: this.props.params,
        paramValues: this.props.paramValues,
        setParameter: this.props.setParameter
      }));
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Outer, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, {
      color: "subdued",
      paddingSize: "none"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, {
      style: {
        padding: `0 ${_uiTheme.euiThemeVars.euiSizeL}`
      }
    }, this.renderTabs())), /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, {
      paddingSize: "l"
    }, this.renderHeader(), paramsForm, this.renderCallOut(), this.renderInstructions()));
  }
}
const instructionShape = _propTypes.default.shape({
  title: _propTypes.default.string,
  textPre: _propTypes.default.string,
  commands: _propTypes.default.arrayOf(_propTypes.default.string),
  textPost: _propTypes.default.string
});
const instructionVariantShape = _propTypes.default.shape({
  id: _propTypes.default.string.isRequired,
  instructions: _propTypes.default.arrayOf(instructionShape).isRequired,
  initialSelected: _propTypes.default.bool
});
const statusCheckConfigShape = _propTypes.default.shape({
  success: _propTypes.default.string,
  error: _propTypes.default.string,
  title: _propTypes.default.string,
  text: _propTypes.default.string,
  btnLabel: _propTypes.default.string,
  customStatusCheck: _propTypes.default.string
});
InstructionSetUi.propTypes = {
  title: _propTypes.default.string.isRequired,
  callOut: _propTypes.default.object,
  instructionVariants: _propTypes.default.arrayOf(instructionVariantShape).isRequired,
  statusCheckConfig: statusCheckConfigShape,
  statusCheckState: _propTypes.default.oneOf([StatusCheckStates.FETCHING, StatusCheckStates.NOT_CHECKED, StatusCheckStates.HAS_DATA, StatusCheckStates.NO_DATA, StatusCheckStates.ERROR]),
  onStatusCheck: _propTypes.default.func.isRequired,
  offset: _propTypes.default.number.isRequired,
  params: _propTypes.default.array,
  paramValues: _propTypes.default.object.isRequired,
  setParameter: _propTypes.default.func,
  replaceTemplateStrings: _propTypes.default.func.isRequired,
  isCloudEnabled: _propTypes.default.bool.isRequired
};
const InstructionSet = exports.InstructionSet = (0, _i18nReact.injectI18n)(InstructionSetUi);