"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Instruction = Instruction;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _content = require("./content");
var _eui = require("@elastic/eui");
var _kibana_services = require("../../kibana_services");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function Instruction({
  commands,
  paramValues,
  textPost,
  textPre,
  replaceTemplateStrings,
  customComponentName,
  variantId,
  isCloudEnabled
}) {
  var _theme$getTheme$darkM;
  const {
    tutorialService,
    http,
    theme,
    getBasePath,
    kibanaVersion
  } = (0, _kibana_services.getServices)();
  let pre;
  if (textPre) {
    pre = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_content.Content, {
      text: replaceTemplateStrings(textPre)
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }));
  }
  let post;
  if (textPost) {
    post = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), /*#__PURE__*/_react.default.createElement(_content.Content, {
      text: replaceTemplateStrings(textPost)
    }));
  }
  const customComponent = tutorialService.getCustomComponent(customComponentName);
  //Memoize the custom component so it wont rerender everytime
  const LazyCustomComponent = (0, _react.useMemo)(() => {
    if (customComponent) {
      return /*#__PURE__*/_react.default.lazy(() => customComponent());
    }
  }, [customComponent]);
  let commandBlock;
  if (commands) {
    const cmdText = commands.map(cmd => {
      return replaceTemplateStrings(cmd, paramValues);
    }).join('\n');
    commandBlock = /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
      isCopyable: true,
      language: "bash"
    }, cmdText);
  }
  const darkTheme = (_theme$getTheme$darkM = theme === null || theme === void 0 ? void 0 : theme.getTheme().darkMode) !== null && _theme$getTheme$darkM !== void 0 ? _theme$getTheme$darkM : false;
  return /*#__PURE__*/_react.default.createElement("div", null, pre, commandBlock, LazyCustomComponent && /*#__PURE__*/_react.default.createElement(_react.Suspense, {
    fallback: /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, null)
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiErrorBoundary, null, /*#__PURE__*/_react.default.createElement(LazyCustomComponent, {
    basePath: getBasePath(),
    isDarkTheme: darkTheme,
    http: http,
    variantId: variantId,
    isCloudEnabled: isCloudEnabled,
    kibanaVersion: kibanaVersion
  }))), post);
}
Instruction.propTypes = {
  commands: _propTypes.default.array,
  paramValues: _propTypes.default.object.isRequired,
  textPost: _propTypes.default.string,
  textPre: _propTypes.default.string,
  replaceTemplateStrings: _propTypes.default.func.isRequired,
  customComponentName: _propTypes.default.string,
  variantId: _propTypes.default.string,
  isCloudEnabled: _propTypes.default.bool.isRequired
};