"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GettingStarted = void 0;
var _react = _interopRequireWildcard(require("react"));
var _queryString = require("query-string");
var _eui = require("@elastic/eui");
var _reactRouterDom = require("react-router-dom");
var _analytics = require("@kbn/analytics");
var _i18n = require("@kbn/i18n");
var _sharedUxPageKibanaTemplate = require("@kbn/shared-ux-page-kibana-template");
var _guide = require("@kbn/guided-onboarding/guide");
var _classic = require("@kbn/guided-onboarding/classic");
var _kibana_services = require("../../kibana_services");
var _home = require("../home");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const homeBreadcrumb = _i18n.i18n.translate('home.breadcrumbs.homeTitle', {
  defaultMessage: 'Home'
});
const gettingStartedBreadcrumb = _i18n.i18n.translate('home.breadcrumbs.gettingStartedTitle', {
  defaultMessage: 'Setup guides'
});
const title = _i18n.i18n.translate('home.guidedOnboarding.gettingStarted.useCaseSelectionTitle', {
  defaultMessage: 'What would you like to do first?'
});
const subtitle = _i18n.i18n.translate('home.guidedOnboarding.gettingStarted.useCaseSelectionSubtitle', {
  defaultMessage: `Filter by solution to see related use cases`
});
const skipText = _i18n.i18n.translate('home.guidedOnboarding.gettingStarted.skip.buttonLabel', {
  defaultMessage: `I’d like to explore on my own.`
});
const GettingStarted = () => {
  const {
    application,
    trackUiMetric,
    chrome,
    guidedOnboardingService,
    cloud
  } = (0, _kibana_services.getServices)();
  const [guidesState, setGuidesState] = (0, _react.useState)([]);
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const [isError, setIsError] = (0, _react.useState)(false);
  const [filteredCards, setFilteredCards] = (0, _react.useState)();
  const {
    search
  } = (0, _reactRouterDom.useLocation)();
  const query = (0, _queryString.parse)(search);
  // using for A/B testing
  const [classicGuide] = (0, _react.useState)(false);
  const useCase = query.useCase;
  const [filter, setFilter] = (0, _react.useState)(classicGuide ? useCase !== null && useCase !== void 0 ? useCase : 'all' : useCase !== null && useCase !== void 0 ? useCase : 'search');
  const history = (0, _reactRouterDom.useHistory)();
  (0, _react.useEffect)(() => {
    chrome.setBreadcrumbs([{
      // using # prevents a reloading of the whole app when clicking the breadcrumb
      href: '#',
      text: homeBreadcrumb,
      onClick: () => {
        trackUiMetric(_analytics.METRIC_TYPE.CLICK, 'guided_onboarding__home_breadcrumb');
      }
    }, {
      text: gettingStartedBreadcrumb
    }]);
  }, [chrome, trackUiMetric]);
  const fetchGuidesState = (0, _react.useCallback)(async () => {
    setIsLoading(true);
    setIsError(false);
    try {
      const allGuides = await (guidedOnboardingService === null || guidedOnboardingService === void 0 ? void 0 : guidedOnboardingService.fetchAllGuidesState());
      setIsLoading(false);
      if (allGuides) {
        setGuidesState(allGuides.state);
      }
    } catch (error) {
      setIsLoading(false);
      setIsError(true);
    }
  }, [guidedOnboardingService]);
  (0, _react.useEffect)(() => {
    fetchGuidesState();
  }, [fetchGuidesState]);
  (0, _react.useEffect)(() => {
    if ((cloud === null || cloud === void 0 ? void 0 : cloud.isCloudEnabled) === false) {
      return history.push('/');
    }
  }, [cloud, history]);
  (0, _react.useEffect)(() => {
    // disable welcome screen on the home page
    localStorage.setItem(_home.KEY_ENABLE_WELCOME, JSON.stringify(false));
  }, []);
  const onSkip = async () => {
    try {
      await (guidedOnboardingService === null || guidedOnboardingService === void 0 ? void 0 : guidedOnboardingService.skipGuidedOnboarding());
    } catch (error) {
      // if the state update fails, it's safe to ignore the error
    }
    trackUiMetric(_analytics.METRIC_TYPE.CLICK, 'guided_onboarding__skipped');
    application.navigateToApp('home');
  };
  const activateGuide = (0, _react.useCallback)(async (guideId, guideState) => {
    try {
      await (guidedOnboardingService === null || guidedOnboardingService === void 0 ? void 0 : guidedOnboardingService.activateGuide(guideId, guideState));
    } catch (err) {
      (0, _kibana_services.getServices)().toastNotifications.addDanger({
        title: _i18n.i18n.translate('home.guidedOnboarding.gettingStarted.activateGuide.errorMessage', {
          defaultMessage: 'Unable to start the guide. Wait a moment and try again.'
        }),
        text: err.message
      });
    }
  }, [guidedOnboardingService]);

  // filter cards for solution and based on classic or new format
  const guide = classicGuide ? _classic.guideCardsClassic : _guide.guideCards;
  (0, _react.useEffect)(() => {
    const tempFiltered = guide.filter(({
      solution
    }) => solution === filter);
    setFilteredCards(tempFiltered);
  }, [filter, guide]);
  if (isLoading) {
    return /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate.EmptyPrompt, {
      title: /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
        size: "xl"
      }),
      body: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        color: "subdued"
      }, _i18n.i18n.translate('home.guidedOnboarding.gettingStarted.loadingIndicator', {
        defaultMessage: 'Loading the guide state...'
      })),
      "data-test-subj": "onboarding--loadingIndicator"
    });
  }
  if (isError) {
    return /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate.EmptyPrompt, {
      iconType: "warning",
      color: "danger",
      title: /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('home.guidedOnboarding.gettingStarted.errorSectionTitle', {
        defaultMessage: 'Unable to load the guide state'
      })),
      body: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        color: "subdued"
      }, _i18n.i18n.translate('home.guidedOnboarding.gettingStarted.errorSectionDescription', {
        defaultMessage: `The guide couldn't be loaded. Wait a moment and try again.`
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        iconSide: "right",
        onClick: fetchGuidesState,
        iconType: "refresh",
        color: "danger"
      }, _i18n.i18n.translate('home.guidedOnboarding.gettingStarted.errorSectionRefreshButton', {
        defaultMessage: 'Refresh'
      }))),
      "data-test-subj": "onboarding--errorSection"
    });
  }
  const setGuideFilters = classicGuide ? /*#__PURE__*/_react.default.createElement(_classic.GuideFiltersClassic, {
    application: application,
    activeFilter: filter,
    setActiveFilter: setFilter,
    "data-test-subj": "onboarding--guideFilters"
  }) : /*#__PURE__*/_react.default.createElement(_guide.GuideFilters, {
    application: application,
    activeFilter: filter,
    setActiveFilter: setFilter,
    "data-test-subj": "onboarding--guideFilters",
    trackUiMetric: trackUiMetric
  });
  const setGuideCards = classicGuide ? /*#__PURE__*/_react.default.createElement(_classic.GuideCardsClassic, {
    activateGuide: activateGuide,
    navigateToApp: application.navigateToApp,
    activeFilter: filter,
    guidesState: guidesState
  }) : /*#__PURE__*/_react.default.createElement(_guide.GuideCards, {
    activateGuide: activateGuide,
    navigateToApp: application.navigateToApp,
    activeFilter: filter,
    guidesState: guidesState,
    filteredCards: filteredCards
  });
  return /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate, {
    panelled: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.Section, {
    "data-test-subj": "guided-onboarding--landing-page"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "l",
    className: "eui-textCenter"
  }, /*#__PURE__*/_react.default.createElement("h1", null, title)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "m",
    textAlign: "center"
  }, /*#__PURE__*/_react.default.createElement("p", null, subtitle)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), setGuideFilters, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xxl"
  }), setGuideCards, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xxl"
  }), /*#__PURE__*/_react.default.createElement("div", {
    className: "eui-textCenter"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    onClick: onSkip,
    "data-test-subj": "onboarding--skipGuideLink"
  }, skipText))));
};
exports.GettingStarted = GettingStarted;