"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerPutPluginStateRoute = exports.registerGetPluginStateRoute = void 0;
var _configSchema = require("@kbn/config-schema");
var _saved_objects = require("../saved_objects");
var _plugin_state_utils = require("../helpers/plugin_state_utils");
var _common = require("../../common");
var _helpers = require("../helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const registerGetPluginStateRoute = router => {
  router.get({
    path: `${_common.API_BASE_PATH}/state`,
    validate: false
  }, async (context, request, response) => {
    const coreContext = await context.core;
    const savedObjectsClient = coreContext.savedObjects.getClient({
      includedHiddenTypes: [_saved_objects.pluginStateSavedObjectsType, _saved_objects.guideStateSavedObjectsType]
    });
    const pluginState = await (0, _plugin_state_utils.getPluginState)(savedObjectsClient);
    return response.ok({
      body: {
        pluginState
      }
    });
  });
};
exports.registerGetPluginStateRoute = registerGetPluginStateRoute;
const registerPutPluginStateRoute = router => {
  router.put({
    path: `${_common.API_BASE_PATH}/state`,
    validate: {
      body: _configSchema.schema.object({
        status: _configSchema.schema.maybe(_configSchema.schema.string()),
        guide: _configSchema.schema.maybe(_configSchema.schema.object({
          status: _configSchema.schema.string(),
          guideId: _configSchema.schema.string(),
          isActive: _configSchema.schema.boolean(),
          steps: _configSchema.schema.arrayOf(_configSchema.schema.object({
            status: _configSchema.schema.string(),
            id: _configSchema.schema.string()
          })),
          // params are dynamic values
          params: _configSchema.schema.maybe(_configSchema.schema.object({}, {
            unknowns: 'allow'
          }))
        }))
      })
    }
  }, async (context, request, response) => {
    const {
      status,
      guide
    } = request.body;
    const coreContext = await context.core;
    const savedObjectsClient = coreContext.savedObjects.getClient({
      includedHiddenTypes: [_saved_objects.pluginStateSavedObjectsType, _saved_objects.guideStateSavedObjectsType]
    });
    if (status) {
      await (0, _plugin_state_utils.updatePluginStatus)(savedObjectsClient, status);
    }
    if (guide) {
      await (0, _helpers.updateGuideState)(savedObjectsClient, guide);
    }
    const pluginState = await (0, _plugin_state_utils.getPluginState)(savedObjectsClient);
    return response.ok({
      body: {
        pluginState
      }
    });
  });
};
exports.registerPutPluginStateRoute = registerPutPluginStateRoute;