"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerGetGuideStateRoute = void 0;
var _common = require("../../common");
var _helpers = require("../helpers");
var _saved_objects = require("../saved_objects");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const registerGetGuideStateRoute = router => {
  // Fetch all guides state
  router.get({
    path: `${_common.API_BASE_PATH}/guides`,
    validate: false
  }, async (context, request, response) => {
    const coreContext = await context.core;
    const soClient = coreContext.savedObjects.getClient({
      includedHiddenTypes: [_saved_objects.guideStateSavedObjectsType]
    });
    const existingGuides = await (0, _helpers.findAllGuides)(soClient);
    if (existingGuides.total > 0) {
      const guidesState = existingGuides.saved_objects.map(guide => guide.attributes);
      return response.ok({
        body: {
          state: guidesState
        }
      });
    } else {
      // If no SO exists, we assume state hasn't been stored yet and return an empty array
      return response.ok({
        body: {
          state: []
        }
      });
    }
  });
};
exports.registerGetGuideStateRoute = registerGetGuideStateRoute;