"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SelectionToolBar = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SelectionToolBar = ({
  workspace,
  onSetControl
}) => {
  const haveNodes = workspace.nodes.length === 0;
  const selectAllButtonMsg = _i18n.i18n.translate('xpack.graph.sidebar.selections.selectAllButtonTooltip', {
    defaultMessage: 'Select all'
  });
  const selectNoneButtonMsg = _i18n.i18n.translate('xpack.graph.sidebar.selections.selectNoneButtonTooltip', {
    defaultMessage: 'Select none'
  });
  const invertSelectionButtonMsg = _i18n.i18n.translate('xpack.graph.sidebar.selections.invertSelectionButtonTooltip', {
    defaultMessage: 'Invert selection'
  });
  const selectNeighboursButtonMsg = _i18n.i18n.translate('xpack.graph.sidebar.selections.selectNeighboursButtonTooltip', {
    defaultMessage: 'Select neighbours'
  });
  const onSelectAllClick = () => {
    onSetControl('none');
    workspace.selectAll();
    workspace.changeHandler();
  };
  const onSelectNoneClick = () => {
    onSetControl('none');
    workspace.selectNone();
    workspace.changeHandler();
  };
  const onInvertSelectionClick = () => {
    onSetControl('none');
    workspace.selectInvert();
    workspace.changeHandler();
  };
  const onSelectNeighboursClick = () => {
    onSetControl('none');
    workspace.selectNeighbours();
    workspace.changeHandler();
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    className: "vertexSelectionTypesBar",
    justifyContent: "flexStart",
    gutterSize: "s",
    alignItems: "center",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: selectAllButtonMsg
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "graphSelectAll",
    size: "s",
    isDisabled: haveNodes,
    color: "text",
    onClick: onSelectAllClick
  }, _i18n.i18n.translate('xpack.graph.sidebar.selections.selectAllButtonLabel', {
    defaultMessage: 'all'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: selectNoneButtonMsg
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "graphSelectNone",
    size: "s",
    isDisabled: haveNodes,
    color: "text",
    onClick: onSelectNoneClick
  }, _i18n.i18n.translate('xpack.graph.sidebar.selections.selectNoneButtonLabel', {
    defaultMessage: 'none'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: invertSelectionButtonMsg
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "graphInvertSelection",
    size: "s",
    isDisabled: haveNodes,
    color: "text",
    onClick: onInvertSelectionClick
  }, _i18n.i18n.translate('xpack.graph.sidebar.selections.invertSelectionButtonLabel', {
    defaultMessage: 'invert'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: selectNeighboursButtonMsg
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "graphLinkedSelection",
    size: "s",
    isDisabled: workspace.selectedNodes.length === 0,
    color: "text",
    onClick: onSelectNeighboursClick
  }, _i18n.i18n.translate('xpack.graph.sidebar.selections.selectNeighboursButtonLabel', {
    defaultMessage: 'linked'
  })))));
};
exports.SelectionToolBar = SelectionToolBar;