"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SelectedNodeEditor = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _icon_renderer = require("../icon_renderer");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SelectedNodeEditor = ({
  workspace,
  selectedNode
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const groupButtonMsg = _i18n.i18n.translate('xpack.graph.sidebar.groupButtonTooltip', {
    defaultMessage: 'group the currently selected items into {latestSelectionLabel}',
    values: {
      latestSelectionLabel: selectedNode.label
    }
  });
  const ungroupButtonMsg = _i18n.i18n.translate('xpack.graph.sidebar.ungroupButtonTooltip', {
    defaultMessage: 'ungroup {latestSelectionLabel}',
    values: {
      latestSelectionLabel: selectedNode.label
    }
  });
  const onGroupButtonClick = () => {
    workspace.groupSelections(selectedNode);
  };
  const onClickUngroup = () => {
    workspace.ungroup(selectedNode);
  };
  const onChangeSelectedVertexLabel = event => {
    selectedNode.label = event.target.value;
    workspace.changeHandler();
  };
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "gphSidebar__panel"
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "gphSidebar__header"
  }, /*#__PURE__*/_react.default.createElement(_icon_renderer.IconRenderer, {
    icon: selectedNode.icon,
    color: euiTheme.colors.darkShade
  }), ' ', selectedNode.data.field, " ", selectedNode.data.term), (workspace.selectedNodes.length > 1 || workspace.selectedNodes.length > 0 && workspace.selectedNodes[0] !== selectedNode) && /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: groupButtonMsg
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "fold",
    onClick: onGroupButtonClick
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.graph.sidebar.groupButtonLabel",
    defaultMessage: "group"
  }))), selectedNode.numChildren > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: ungroupButtonMsg
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "unfold",
    onClick: onClickUngroup
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.graph.sidebar.ungroupButtonLabel",
    defaultMessage: "ungroup"
  }))), /*#__PURE__*/_react.default.createElement("form", {
    className: "form-horizontal"
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "form-group form-group-sm gphFormGroup--small"
  }, /*#__PURE__*/_react.default.createElement("label", {
    htmlFor: "labelEdit",
    className: "col-sm-3 control-label"
  }, _i18n.i18n.translate('xpack.graph.sidebar.displayLabelLabel', {
    defaultMessage: 'Display label'
  })), /*#__PURE__*/_react.default.createElement("div", {
    className: "col-sm-9"
  }, /*#__PURE__*/_react.default.createElement("input", {
    ref: element => element && (element.value = selectedNode.label),
    type: "text",
    id: "labelEdit",
    className: "form-control input-sm",
    onChange: onChangeSelectedVertexLabel
  }), /*#__PURE__*/_react.default.createElement("div", {
    className: "help-block"
  }, _i18n.i18n.translate('xpack.graph.sidebar.displayLabelHelpText', {
    defaultMessage: 'Change the label for this vertex.'
  }))))));
};
exports.SelectedNodeEditor = SelectedNodeEditor;