"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerCreateRoute = void 0;
var _configSchema = require("@kbn/config-schema");
var _utils = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const registerCreateRoute = router => {
  router.post({
    path: `${_utils.KBN_CLIENT_API_PREFIX}/{type}/{id?}`,
    options: {
      tags: ['access:ftrApis']
    },
    validate: {
      params: _configSchema.schema.object({
        type: _configSchema.schema.string(),
        id: _configSchema.schema.maybe(_configSchema.schema.string())
      }),
      query: _configSchema.schema.object({
        overwrite: _configSchema.schema.boolean({
          defaultValue: false
        })
      }),
      body: _configSchema.schema.object({
        attributes: _configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.any()),
        migrationVersion: _configSchema.schema.maybe(_configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.string())),
        references: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.object({
          name: _configSchema.schema.string(),
          type: _configSchema.schema.string(),
          id: _configSchema.schema.string()
        })))
      })
    }
  }, (0, _utils.catchAndReturnBoomErrors)(async (ctx, req, res) => {
    const {
      type,
      id
    } = req.params;
    const {
      overwrite
    } = req.query;
    const {
      attributes,
      migrationVersion,
      references
    } = req.body;
    const {
      savedObjects
    } = await ctx.core;
    const hiddenTypes = (0, _utils.listHiddenTypes)(savedObjects.typeRegistry);
    const soClient = savedObjects.getClient({
      includedHiddenTypes: hiddenTypes
    });
    const options = {
      id,
      overwrite,
      migrationVersion,
      references
    };
    const result = await soClient.create(type, attributes, options);
    return res.ok({
      body: result
    });
  }));
};
exports.registerCreateRoute = registerCreateRoute;