"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isDefaultAgentlessPolicyEnabled = exports.isAgentlessEnabled = exports.isAgentlessApiEnabled = void 0;
Object.defineProperty(exports, "isOnlyAgentlessIntegration", {
  enumerable: true,
  get: function () {
    return _agentless_policy_helper.isOnlyAgentlessIntegration;
  }
});
exports.prependAgentlessApiBasePathToEndpoint = void 0;
var _ = require("..");
var _agentless_policy_helper = require("../../../common/services/agentless_policy_helper");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const isAgentlessApiEnabled = () => {
  var _appContextService$ge, _appContextService$ge2;
  const cloudSetup = _.appContextService.getCloud && _.appContextService.getCloud();
  const isHosted = (cloudSetup === null || cloudSetup === void 0 ? void 0 : cloudSetup.isCloudEnabled) || (cloudSetup === null || cloudSetup === void 0 ? void 0 : cloudSetup.isServerlessEnabled);
  return Boolean(isHosted && ((_appContextService$ge = _.appContextService.getConfig()) === null || _appContextService$ge === void 0 ? void 0 : (_appContextService$ge2 = _appContextService$ge.agentless) === null || _appContextService$ge2 === void 0 ? void 0 : _appContextService$ge2.enabled));
};
exports.isAgentlessApiEnabled = isAgentlessApiEnabled;
const isDefaultAgentlessPolicyEnabled = () => {
  const cloudSetup = _.appContextService.getCloud && _.appContextService.getCloud();
  return Boolean((cloudSetup === null || cloudSetup === void 0 ? void 0 : cloudSetup.isServerlessEnabled) && _.appContextService.getExperimentalFeatures().agentless);
};
exports.isDefaultAgentlessPolicyEnabled = isDefaultAgentlessPolicyEnabled;
const isAgentlessEnabled = () => {
  return isAgentlessApiEnabled() || isDefaultAgentlessPolicyEnabled();
};
exports.isAgentlessEnabled = isAgentlessEnabled;
const AGENTLESS_ESS_API_BASE_PATH = '/api/v1/ess';
const AGENTLESS_SERVERLESS_API_BASE_PATH = '/api/v1/serverless';
const prependAgentlessApiBasePathToEndpoint = (agentlessConfig, endpoint) => {
  const cloudSetup = _.appContextService.getCloud && _.appContextService.getCloud();
  const endpointPrefix = cloudSetup !== null && cloudSetup !== void 0 && cloudSetup.isServerlessEnabled ? AGENTLESS_SERVERLESS_API_BASE_PATH : AGENTLESS_ESS_API_BASE_PATH;
  return `${agentlessConfig.api.url}${endpointPrefix}${endpoint}`;
};
exports.prependAgentlessApiBasePathToEndpoint = prependAgentlessApiBasePathToEndpoint;